// GEN.CC : Fichero cabecera de las funciones del algoritmo genVartico.

#include <stdlib.h>
#include <sys/types.h>
#include <string.h>
#include <math.h>			// para mysrand y myrand


// header file for this one...
#include "genvar.hpp"

const unsigned LENGTH_0 = 1, SIZE_0 = 2;



// ---------------------------------------------------------------------
void genVar::mutate( double _mutationRate ) {
// --	mutates genome string with given probability
// ---------------------------------------------------------------------

    for ( unsigned i = 0; i < length*8; i ++ )
	if ( ( myrand(10000)/10000.0 ) < _mutationRate)
	    changeBit( i );

}


// ---------------------------------------------------------------------
void genVar::checkNassign( unsigned _numAlleles, unsigned _sizeAllele) {
//  --	Checks number of alleles and size, and assigns values to the instance
//	variables
// ---------------------------------------------------------------------
    if (!_numAlleles) {
	    printf( "Null number of alleles\n" );
	    exit( LENGTH_0 );
    }

    if (!_sizeAllele) {
	    printf( "Alleles of zero length\n" );
	    exit( SIZE_0 );
    }

    length = _numAlleles * _sizeAllele;
    size = _sizeAllele;
    maxForSize = (unsigned long) pow(256, size);
    str = new char[ length ];

    if (!str) {
	    printf( "New failed in genVar::genVar(u,u) - str\n");
	    exit(1);
    }
}

// ---------------------------------------------------------------------
genVar::genVar(  unsigned _numAlleles, unsigned _sizeAllele ) {
// ---------------------------------------------------------------------

	checkNassign(  _numAlleles, _sizeAllele);
	for ( int i = 0; i < length; i ++ )
		str[i] = myrand(256);
}


// ---------------------------------------------------------------------
// genVar( char *inStr ) --	To construct a chromosome from a string
// ---------------------------------------------------------------------
genVar::genVar( char *_str, unsigned _numAlleles, unsigned _sizeAllele  )
{

	checkNassign( _numAlleles,  _sizeAllele);
	memcpy( str, _str, length );
}

// ---------------------------------------------------------------------
// genVar::genVar( char *_str, float mutationRate );
//	-- builds a chromosome from a string, with a fixed mutation rate
// ---------------------------------------------------------------------
genVar::genVar( char *_str, unsigned _length, float _mutationRate )
{
	size = 1;
	maxForSize = 256;
	length = _length;

	str = new char[length];

	if (!str)
		printf( "New failed in genVar::genVar - str\n");
	memcpy( str, _str, length );

	// now performs mutation
	mutate( _mutationRate); 
}


// ---------------------------------------------------------------------
// genVar( genVar &genVar1, genVar &genVar2, float xOverRate, float MutationRate);
//	-- 	Builds a genVare from genVare1 applying multipoint crossover
//		and mutation with given probabilities (over 1)
// ---------------------------------------------------------------------
genVar::genVar( genVar &genVar1, genVar &genVar2, double xOverRate, double MutationRate)
{
// Starting with gene 1
	unsigned auxL = length = genVar1.getLength(); 	// computes length
	size = genVar1.getSize();
	maxForSize = ( unsigned long) pow(256, size);
	if (!(str = new char[auxL])) {			// allocs memory
		printf( "New failed in genVar::genVar 2 - str\n");
		exit(1);
	}

	memcpy( str, genVar1.getGenome(), length);	// copies into genVarome

	mutate( MutationRate );				// changes bits randomly
	unsigned auxL2 = genVar2.getLength();

	if ( auxL2 < auxL )				// take smaller one
		auxL = auxL2;

	for ( unsigned long i = 0; i < auxL*8; i ++ )
		if ( ( myrand(10000)/10000.0 ) < xOverRate)
			swapBit( i, genVar2.getGenome() ); // changes bits randomly

}


// ---------------------------------------------------------------------
genVar::genVar( genVar &genVar1, genVar &genVar2, double xOverRate)
//	-- 	Builds a gene from genVare1 applying only multipoint crossover
//		(uniform crossover)
// ---------------------------------------------------------------------
{
// Starting with genVare1
	unsigned auxL = length = genVar1.getLength(); 	// computes length
	size = genVar1.getSize();
	maxForSize = ( unsigned long) pow(256, size);

	if (!(str = new char[auxL]))			// allocs memory
		printf( "New failed in genVar::genVar 2 - str\n");

	memcpy( str, genVar1.getGenome(), length);	// copies into genVarome

	unsigned auxL2 = genVar2.getLength();

	if ( auxL2 < auxL )						// take smaller one
		auxL = auxL2;

	for ( int i = 0; i < auxL*8; i ++ )
		if ( ( myrand(10000)/10000.0 ) < xOverRate)
			swapBit( i, genVar2.getGenome() ); // changes bits randomly

}

// ---------------------------------------------------------------------
genVar::genVar(	genVar &genVar1, 
		genVar &genVar2, 
		unsigned _startPoint, 
		unsigned _endPoint, 
		double _mutationRate )
// --	Builds a genome from 2 others using 2 point crossover with the said
//	points. These 2 points could have been generated inside, but had no "function"
//	formats left
// ---------------------------------------------------------------------
{
	// Starting with gene1 == parent A
	unsigned auxL = length = genVar1.getLength(); 	// computes length
	size = genVar1.getSize();
	maxForSize = ( unsigned long) pow(256, size);

	if (!(str = new char[auxL])) {			// allocs memory
		printf( "New failed in genVar::genVar 2 - str\n");
		exit(1);
	}

	memcpy( str, genVar1.getGenome(), length);	// copies into genome

	unsigned auxL2 = genVar2.getLength();

	if ( auxL2 < auxL )				// take smaller one
	    auxL = auxL2;

	// swapping as needed
	if ( _startPoint > _endPoint ) 
	    swap( _startPoint,  _endPoint );
	
	// check bounds; auxL is the smaller of the two
	if (_endPoint > auxL*8 )
	    _endPoint = auxL*8;
	    
	// now perform interchange
	swapChunk( _startPoint, _endPoint, genVar2.getGenome() );
	
	// and then mutate
	mutate( _mutationRate );
}


// --------------------------------------------------------------------
// genVar( genVar &genVar1, double MutationRate);
//	--	Builds a genVarome by mutating genVare1, with given MutationRate
// ---------------------------------------------------------------------
genVar::genVar( genVar &genVar1, double MutationRate)
{
	unsigned auxL = genVar1.getLength(); 		// computes length
	size = genVar1.getSize();
	maxForSize = ( unsigned long) pow(256, size);
	
	str = new char[auxL];				// allocs memory

	length= auxL;

	memcpy( str, genVar1.getGenome(), length);	// copies into genome

	mutate( MutationRate );
	
}


// --------------------------------------------------------------------
// genVar( genVar &genVar1, float MutationRate, float killRate, float dupRate);
//	--	Builds a genVarome by mutating genVare1, with given MutationRate
// ---------------------------------------------------------------------
genVar::genVar( genVar &genVar1, double MutationRate, double killRate, double dupRate)
{
	unsigned auxL = genVar1.getLength(); 		// computes length
	size = genVar1.getSize();
	maxForSize = ( unsigned long) pow(256, size);
	str = new char[auxL];				// allocs memory
	length= auxL;

	memcpy( str, genVar1.getGenome(), length);	// copies into genVarome

	mutate( MutationRate );
	
	if ( myrand(10000)/10000.0 < dupRate)
		dupAllele( myrand( auxL ), MutationRate );

	if ( myrand(10000)/10000.0 < killRate)
		killAllele( myrand( auxL ) );
}


// --------------------------------------------------------------------
// genVar( genVar &genVar1, genVar &genVar2
//		float MutationRate, float xOverRate, float killRate, float dupRate);
//	--	Builds a genome by mutating genVare1, with given MutationRate
// ---------------------------------------------------------------------
genVar::genVar( genVar &genVar1, genVar &genVar2,
		double xOverRate, double MutationRate, 
		double killRate, double dupRate)
{
	unsigned auxL = genVar1.getLength(); 		// computes length
	size = genVar1.getSize();
	maxForSize = ( unsigned long) pow(256, size);
	str = new char[auxL];				// allocs memory
	length= auxL;

	memcpy( str, genVar1.getGenome(), length);	// copies into genome

	for ( int i = 0; i < auxL*8; i ++ )
		if ( ( myrand(10000)/10000.0 ) < xOverRate)
			swapBit( i, genVar2.getGenome() ); 
			
	mutate( MutationRate);
	
	if ( myrand(10000)/10000.0 < dupRate)
		dupAllele( myrand( auxL ), MutationRate );

	if ( myrand(10000)/10000.0 < killRate)
		killAllele( myrand( auxL ) );
}


// --------------------------------------------------------------------
genVar::genVar( genVar& genVar1,  
		varLenOpMode _modeOp, 
		unsigned _geneIdx, 
		double _mutationRate )	{
// --	creates a new genome using one of 3 modes; using _geneIdx if
//	needed, _mutationRate is used only for duplication
// ---------------------------------------------------------------------



    // all instance variables get initialized
    
    length	= genVar1.getLength(); 	// computes length
    size	= genVar1.getSize();
    maxForSize	= ( unsigned long) pow(256, size); 

    if ( !(str = new char[length]) ) {	// allocs memory
	printf( "Memory could not be alloc'ed for gene string\n");
	exit( 1 );
    }

    memcpy( str, genVar1.getGenome(), length);	// copies into genome

    
    // now applies unary genetic operator as specified to the newly
    // created genome
    switch( _modeOp ) {
	case DUP :
	    dupAllele( _geneIdx, _mutationRate );
	    break;
	case KILL :
	    killAllele( _geneIdx );
	    break;
	case RANDINC :
	    addAllele();
	    break;
    }
   
}


// --------------------------------------------------------------------
// void changeBit -- changes a single bit in the string
// --------------------------------------------------------------------
void genVar::changeBit ( unsigned long chBit)
{

    unsigned long chByte = chBit >> 3;
    // Se altera el bit de la posicin rnd (se le hace XOR)
    // bit in chBit position is altered (by XORing it)
    str[chByte] ^= Wgts[(chBit & 7)+1];
}


// -------------------------------------------------------------------------
// void swapBit -- swaps a single bit in the string with the internal string
// -------------------------------------------------------------------------
void genVar::swapBit ( unsigned long swBit, char* inStr)
{
    unsigned long swByte = swBit >> 3;

    // Se altera el bit de la posicion rnd (se le hace XOR)
    // bit in swBit position is altered (by XORing it)
    str[swByte] &= ~Wgts[(swBit & 7)+1];
    // pone a 0 el bit que quieres copiar
    str[swByte] |= (inStr[swByte] & Wgts [(swBit & 7)+1]);
    // copia el bit
}

// -------------------------------------------------------------------------
void genVar::swapChunkByte	(   unsigned char _scbStart,
				    unsigned char _scbEnd,
				    unsigned _idxByte, 
				    char _scbByte) {
// --	swaps a chunk of bits between the internal byte of index idxByte
//	and the input byte
// -------------------------------------------------------------------------

    // first; creation of the mask
    unsigned char mask=0;
    unsigned char oneLeft = 128;
    unsigned char oneRight = 1;
    
    // first, create mask from left
    for ( unsigned char i = 0; i < _scbStart; i ++ ) {
	mask |= oneLeft;
	oneLeft >>=1;
    }
    
    // now, from right
    for ( i = 7; i>  _scbEnd; i-- ) {
	mask |= oneRight;
	oneRight <<=1;
    }
    
    // mask created :-) Now interchange.
    str[_idxByte] &= mask;
    _scbByte &= ~mask;
    
    str[_idxByte]|=_scbByte;
}


// -------------------------------------------------------------------------
void genVar::swapChunk	(   unsigned long _swBitStart,
			    unsigned long _swBitEnd,
			    char *inStr ) {
//  --	swaps all the bytes between the start bit and the end bit;
//	ie. from 0 to _swBit_start from the inside string; from _swBitStart
//	to _swBitEnd from the second string, and from _swBitEnd to the final
//	bit from the inside string
//	Good for 2-point crossover
//	Boundary check is on the user
// -------------------------------------------------------------------------

    unsigned long byteStart = _swBitStart   / 8;
    unsigned long byteEnd   = _swBitEnd	    / 8;
    
    if ( byteStart == byteEnd )
	swapChunkByte( _swBitStart%8, _swBitEnd %8, byteStart, inStr[byteStart]);
    else  { // different
	// start byte
	swapChunkByte(  _swBitStart%8,  7, byteStart, inStr[byteStart] );
	
	// middle bytes
	for (unsigned long i = byteStart + 1; i < byteEnd; i ++ )
	    str[i] = inStr[i];
	    
	// end byte
	swapChunkByte( 0, _swBitEnd %8, byteEnd, inStr[byteEnd]);
    }
			    
}


// ---------------------------------------------------------------------
// getAllele- gets a string of size --size--
// ---------------------------------------------------------------------
void  genVar::getAllele( unsigned idx, char* _inStr ) const {
	memcpy( _inStr, str + idx*size, size );
}


// ---------------------------------------------------------------------
// getAllele- gets a string of size --size--
// ---------------------------------------------------------------------
char * genVar::getAllele( unsigned idx ) const {
    char * aux=new char[size];
    memcpy( aux, str + idx*size, size );
    return aux;
}


// ---------------------------------------------------------------------
// addAllele --  adds another allele (size bytes) at the end of the string
// ---------------------------------------------------------------------
void genVar::addAllele( ) {

	char *tmp = new char[length+size];

	if ( !tmp )
		printf( "New failed in addAllele - tmp\n");

	memcpy( tmp, str, length );		// copies old string

	delete []str;				// deallocs memory and allocs again
	str = new char[length + size];
	if (!str)
		printf( "New failed in addAllele - str\n");
	memcpy( str, tmp, length );
	length+=size;
	delete []tmp;

	for ( unsigned i = 1; i <= size; i ++ )
		str[ length - i ] = myrand( 256 ); 	// assigns random values

}

// ---------------------------------------------------------------------
// void killAllele -- deletes an allele from position idx, redims string
// ---------------------------------------------------------------------
void genVar::killAllele(  unsigned _pos ){

	if ( _pos * size > length )
		return;
		
	if ( length <= size ) {			// return if there is nothing left
		printf( "Small enough, thanks\n" );
		return;
	}

	// everything is fine; now go on

	char *tmp = new char[length];	
	if (!tmp) {
		printf( "New failed in killAllele - tmp\n");
		return;
	}
	unsigned charIdx = size*_pos;
	memcpy( tmp, str, charIdx );		// copies old string, up to idx
	memcpy( tmp + charIdx, str + charIdx + size, length - charIdx - size);
									// and from idx

	delete []str;						// deallocs memory and allocs again
	length -= size;
	str = new char[length];
	if (!str)
		printf( "New failed in killAllele - str\n");
	memcpy( str, tmp, length );     // with new length
	delete []tmp;						// deallocs temp var

}

// ---------------------------------------------------------------------
// void dupAllele -- duplicates the given allele with errors
// ---------------------------------------------------------------------
void genVar::dupAllele(  unsigned _pos, double MutationRate ) {

	if ( _pos * size > length )
		return;
	// everything is fine; now go on

	char *tmp = new char[length + size];
	if (!tmp) {
		printf( "New failed in dupAllele - tmp\n");
		return;
	}

	unsigned charIdx = size*_pos;
	memcpy( tmp, str, charIdx );		// copies old string, up to _pos
	memcpy( tmp + charIdx, str+ charIdx, size ); // dups allele
	memcpy( tmp + charIdx + size, str + charIdx, length - charIdx );

	delete []str;						// deallocs memory and allocs again
	length += size;
	str = new char[length];
	if (!str)
		printf( "New failed in dupAllele - str\n");
	memcpy( str, tmp, length );     // with new length
	delete []tmp;						// deallocs temp var

	for ( int i = 0; i < size*8; i ++ ) // now alters a little bit the new gene
		if ( ( myrand(100)/100.0 ) < MutationRate)
			changeBit( charIdx*8 + i );

}

// ---------------------------------------------------------------------
void genVar::print( void ) {
// ---------------------------------------------------------------------
	for ( int i = 0; i < length; i ++ )
		printf( "%c", str[i] );
	printf("\n" );
}


// -----------------------------------------------------------------------
// Friendly operators
// ------------------

// -----------------------------------------------------------------------
ostream& operator << ( ostream& s, const genVar & _inGen ) {
// --	to print a genVar to stdout
// -----------------------------------------------------------------------

    for ( unsigned long i = 0; i < _inGen.getLength(); i ++ ) 
	s << (unsigned int) _inGen.str[i] << " ";
	
    return s;
}
