//			GENSGAV.HPP
// DESCRIPTION: same as gensga.hpp, but with variable range for each locus
//		in the cromosome.

// LOG: 
// 9-May-1994	: Creacion...
//10-May-1994	:   Cambio pequeito para que, en vez de ser descendiente de gensga
//		    lo es directamente de genvar.
//		    Aniadidos muchos constructores preciosos
//11-May-1994	: Aniadido un constructor ficticio

#ifndef __GENSGAV_HPP
#define __GENSGAV_HPP

#ifndef __BCPLUSPLUS__
#ident "@(#) gensgav.hpp -- by J. J. Merelo"
#endif

#include "genvar.hpp"

template <class returnType>
class genSGAv: public genVar {
    returnType *rangeStartA, *rangeA;	
	
	
    void allocRanges(
	    returnType *_rgStart, 
	    returnType *_rgEnd );
	    
    void allocRanges2(
	    returnType *_rgStart, 
	    returnType *_rg );		    // same as before, but using real ranges
    						
public:


    // constructors and destructors.
    virtual ~genSGAv () {
	delete[] rangeA;
	delete[] rangeStartA;
    }
    
    genSGAv();
    genSGAv(unsigned _numAlleles, 
	    unsigned _sizeAllele, 
	    returnType *_rgStart, 
	    returnType *_rgEnd );
	    
    genSGAv(unsigned _numAlleles, 
	    unsigned _sizeAllele, 
	    returnType _rgStart, 
	    returnType _rgEnd ) {};	    // dummy constructor
	    
    genSGAv( genSGAv &_genSGAv, double _mutationRate ):
	genVar( _genSGAv, _mutationRate ) {
	    allocRanges2( _genSGAv.rangeStartA, _genSGAv.rangeA );
    };
    
    genSGAv( genSGAv &genSGAv1, genSGAv &genSGAv2, 
	    unsigned _startPoint, unsigned _endPoint, 
	    float _mutationRate):
		genVar( genSGAv1, genSGAv2, _startPoint, _endPoint, _mutationRate ) {	
		
		allocRanges2( genSGAv1.rangeStartA, genSGAv1.rangeA );	
	    };
	    
    const returnType operator [] (unsigned _idx) const;
	    
	    
};



// private functions

// --------------------------------------------------------
template <class returnType>
void genSGAv<returnType>::allocRanges(
	    returnType *_rgStart, 
	    returnType *_rgEnd ){
// -- Allocs memory for ranges, and assigns values
// --------------------------------------------------------
	
    // alloc memory
    if ( !(rangeStartA = new returnType[length/size] ) ){
	cout << "No memory for ranges\n";
	exit(1);
    }
    
    if ( !(rangeA = new returnType[length/size] ) ){
	cout << "No memory for ranges\n";
	exit(1);
    }
    
    memcpy( rangeStartA, _rgStart, length/size*sizeof(returnType));
    for (  unsigned i = 0; i < length/size; i ++ ){
	rangeA[i] = _rgEnd[i] - rangeStartA[i];
    }
}


// --------------------------------------------------------
template <class returnType>
void genSGAv<returnType>::allocRanges2(
	    returnType *_rgStart, 
	    returnType *_rg ){
// -- Allocs memory for ranges, and assigns values
// --------------------------------------------------------
	
    // alloc memory
    if ( !(rangeStartA = new returnType[length/size] ) ){
	cout << "No memory for ranges\n";
	exit(1);
    }
    
    if ( !(rangeA = new returnType[length/size] ) ){
	cout << "No memory for ranges\n";
	exit(1);
    }
    
    memcpy( rangeStartA, _rgStart, length/size*sizeof(returnType));
    memcpy( rangeA, _rg, length/size*sizeof(returnType));
    
}

// --------------------------------------------------------
template <class returnType>
genSGAv<returnType>::genSGAv( unsigned _numAlleles, 
	    unsigned _sizeAllele, 
	    returnType *_rgStart, 
	    returnType *_rgEnd ): genVar( _numAlleles,  _sizeAllele) {
// -- main constructor
// --------------------------------------------------------
	
   allocRanges( _rgStart, _rgEnd);
}


// ------------------------------------------------------------------------
template <class returnType> 
const returnType genSGAv<returnType>::operator[] (unsigned _idx ) const {
// --	Returns the allele # idx, bearing in mind the range and the size of
//	the locus. Uses little-endian ordering, representation is sign
//	plus absolute number
// ------------------------------------------------------------------------

    unsigned startPoint = size*_idx;		// computes start point in bytes
    returnType partialSum = 0;
    unsigned long pow256 = 1;
    for ( register int i = size - 1; i >= 0; i -- ) {
#ifdef DEBUG
	cout << (unsigned int)  str[startPoint+i] << " ";
#endif
	partialSum += ((unsigned char) str[startPoint+i]) *pow256;
	pow256*=256;
    }
    return rangeStartA[_idx] + (partialSum*rangeA[_idx])/maxForSize;
};
    
#endif
