// ----------------------------------	 GENSGA.HPP   ------------------------------
// Header file for some nifty implementation of a simple genetic algorithm, using
// a fixed-length version of my beloved variable-length genotype.
// It is template-based, to make it nicer.
// Its supposed to be a string of 0-1 that decodes to a number of type <type>
// within the said range.
// REFERENCES: Goldbergs book, JJs Thesis, and my dim and grim notebook.
// LOG
// 4-May-94 :	Creacion.
// 5-May-94 :	Prosigue la creacion, con el aniadido de nuevos constructores
// 6-May-94 :	Aniadidas las funciones para pasar a Gray, y definido un puntero
//		template
//		Aniadida reproduccion al estilo estrella de mar, de un solo
//		padre con mutacion.
// 9-May-94 :	Cambiados los private a protected, para que se pueda heredar;
//		Creado un constructor sin parametros
//		[] se convierte en virtual
// 10-May-94	Trasladado maxForSize a la clase Base, cuyo [] se convierte
//		en virtual tambien
//		Eliminado rangeEnd
// 11-May-94	Aniadido un ctor ficticio


#ifndef __GENSGA_HPP
#define __GENSGA_HPP

#ifndef __BCPLUSPLUS__
#ident "@(#) gensga.hpp -- By JJ Merelo "
#endif

#include "genvar.hpp"


// useful but not class functions
unsigned char deGray( unsigned char _deG );		// converts from Gray to binary

template <class returnType>
class genSGA: public genVar {
    returnType	rangeStart, range;		// range of _all_ values

protected:
    
    // used from constructors
    setValues( returnType _rgStart, returnType _rgEnd );
    
public:
	
    // constructors and destructors
    virtual ~genSGA() {};	
    genSGA() {};
    genSGA( unsigned _numAlleles, 
	    unsigned _sizeAllele, 
	    returnType _rgStart, 
	    returnType _rgEnd );
	    
    genSGA( unsigned _numAlleles, 
	    unsigned _sizeAllele, 
	    returnType *_rgStart, 
	    returnType *_rgEnd ) {};		// dummy ctor
	    
    genSGA( char* _inStr, 
	    unsigned _numAlleles, 
	    unsigned _sizeAllele, 
	    returnType _rgStart, 
	    returnType _rgEnd );
	  
    genSGA( genSGA &_genSGA, double _mutationRate ):
	genVar( _genSGA, _mutationRate ) {
	    rangeStart  = _genSGA.rangeStart;
	    range	= _genSGA.range;
    }
    
    genSGA( genSGA &genSGA1, genSGA &genSGA2, 
	    unsigned _startPoint, unsigned _endPoint, 
	    float _mutationRate):
		genVar( genSGA1, genSGA2, _startPoint, _endPoint, _mutationRate ) {		
		rangeStart  = genSGA1.rangeStart;
		range	    = genSGA1.range;
	    };
							// 2-point crossover

    // several useful functions
    const returnType	operator[]  ( unsigned _idx ) const;	// returns the allele number idx   
    const void		getVal	    ( unsigned _idx, returnType& _val ) const;
    const void		print	    ( void ) const;
    
    // now functions for fancy Gray decoding
    const returnType	deGray	    ( unsigned _idx ) const;
    
};


// --------------------------	 TEMPLATE DECLARATIONS -------------------


// --------------------------------------------------------
template <class returnType>
genSGA<returnType>::setValues( returnType _rgStart, returnType _rgEnd ) { 
// -- Sets values of genSGA's own variables
// --------------------------------------------------------
    
    // swaps if in incorrect order
    if ( _rgStart > _rgEnd ) 
	swap (_rgStart, _rgEnd );
	
    rangeStart=_rgStart;
    range = _rgEnd - rangeStart;
};


template <class returnType>
inline
genSGA<returnType>::genSGA( 
	    unsigned _numAlleles, 
	    unsigned _sizeAllele, 
	    returnType _rgStart, 
	    returnType _rgEnd ):genVar( _numAlleles,  _sizeAllele) { 
		setValues( _rgStart,  _rgEnd );
};


template <class returnType>
inline
genSGA<returnType>::genSGA(
	    char * _inStr, 
	    unsigned _numAlleles, 
	    unsigned _sizeAllele, 
	    returnType _rgStart, 
	    returnType _rgEnd ):genVar( _inStr, _numAlleles,  _sizeAllele) { 
		setValues( _rgStart,  _rgEnd );
};


// ------------------------------------------------------------------------
template <class returnType> 
const returnType genSGA<returnType>::operator[] (unsigned _idx ) const {
// --	Returns the allele # idx, bearing in mind the range and the size of
//	the locus. Uses little-endian ordering, representation is sign
//	plus absolute number
// ------------------------------------------------------------------------

    unsigned startPoint = size*_idx;		// computes start point in bytes
    returnType partialSum = 0;
    unsigned long pow256 = 1;
    for ( register int i = size - 1; i >= 0; i -- ) {
#ifdef DEBUG
	cout << (unsigned int)  str[startPoint+i] << " ";
#endif
	partialSum += ((unsigned char) str[startPoint+i]) *pow256;
	pow256*=256;
    }
    return rangeStart + (partialSum*range)/maxForSize;
};


// ------------------------------------------------------------------------
template <class returnType>
const void genSGA<returnType>::print () const {
// --	Prints everything
// ------------------------------------------------------------------------

    for ( register unsigned i = 0; i < length/size; i ++ ) {
	unsigned startPoint = size*i;
	returnType partialSum;
	unsigned long pow256 = 1;
	for ( register int j = size - 1; j >= 0; j -- ) {
	    partialSum += ((unsigned char) str[startPoint+j] )*pow256;
	    pow256*=256;
	}
	cout << rangeStart + (partialSum*range)/maxForSize << "\n";
    }
};


// ------------------------------------------------------------------------------
template <class returnType> 
const void genSGA<returnType>::getVal (unsigned _idx,  returnType& _val ) const {
// --	Returns the allele # idx, bearing in mind the range and the size of
//	the locus. Uses little-endian ordering, representation is sign
//	plus absolute number
// ------------------------------------------------------------------------------

    unsigned startPoint = size*_idx;
    returnType partialSum;
    unsigned long pow256 = 1;
    for ( register int i = size - 1; i >= 0; i -- ) {
	partialSum += ((unsigned char) str[startPoint+i] )*pow256;
	pow256*=256;
    }
    _val = rangeStart + (partialSum*range)/maxForSize;
};


// ------------------------------------------------------------------------------
// templates for Gray coding and decoding...
// ------------------------------------------------------------------------------

// ------------------------------------------------------------------------------
template <class returnType> 
const returnType genSGA<returnType>::deGray (unsigned _idx ) const {
// --	Returns the allele # idx, bearing in mind the range and the size of
//	the locus. Uses little-endian ordering, representation is sign
//	plus absolute number; and Gray coding, of course....
// ------------------------------------------------------------------------------

    unsigned startPoint = size*_idx;		// computes start point in bytes
    returnType partialSum = 0;
    unsigned long pow256 = 1;
    for ( register int i = size - 1; i >= 0; i -- ) {
#ifdef DEBUG
	cout << (unsigned int)  str[startPoint+i] << " ";
#endif
	partialSum += deGray(str[startPoint+i]) *pow256;
	pow256*=256;
    }
    return rangeStart + (partialSum*range)/maxForSize;
};  

#endif
