#!/bin/csh

if ( $#argv == 0 ) then
    echo Use install.sh \<machine\>, where machine can be sun or sgi
    exit
endif

set LIBDIR=/usr/local/lib
set BINDIR=/usr/local/bin
set INCDIR=/usr/local/include

ex.sh 
pushd . >/dev/null 
cd src 
make -f Makefile.$1
if ( $status ) exit
popd >/dev/null
if ( ! -e ${LIBDIR} ) mkdir -p ${LIBDIR} 
if ( ! -e ${BINDIR} ) mkdir -p ${BINDIR} 
if ( ! -e ${INCDIR} ) mkdir -p ${INCDIR} 
cp lib/*.gag ${LIBDIR} 
if ( -e "__perlfile" ) then 
    cat __perlfile bin/gags.xp > ${BINDIR}/gags.pl
    chmod +x ${BINDIR}/gags.pl
    mv src/libGAGS.a $LIBDIR
    cp src/*.hpp $INCDIR
    cat __perlfile lib/subgags.xh > ${LIBDIR}/subgags.ph
    chmod +x ${LIBDIR}/subgags.ph
endif
