/************************************************************
;                                                           *
;  William M. Spears					    *
;  Navy Center for Applied Research in AI                   *
;  Naval Research Laboratory                                *
;                                                           *
;  This software is the property of the Department of the   *
;  Navy. Permission is hereby granted to copy all or any    *
;  part of this program for free distribution, however      *
;  this header is required on all copies.		    *
;                                                           *
; File: header.h                                            *
;************************************************************/

#include <stdio.h>
#include <math.h>

#define MAX_BITS 301            /* Maximum length of chromosomes */
#define MAX_POP  5001           /* Maximum population size */

#define MUTATION .001           /* Mutation rate of 0.1% */
#define CROSS_OVER .6           /* Crossover rate of 60% */

#define max(a, b) (a > b) ? a : b
#define min(a, b) (a > b) ? b : a

int p1[MAX_POP][MAX_BITS];	/* Population 1 */
int p2[MAX_POP][MAX_BITS];	/* Population 2 */
int sh[MAX_POP];		/* Shuffle array */
int b[MAX_BITS];		/* Best Individual seen so far */
double f[MAX_POP];		/* Fitness array */
double v1[MAX_POP];		/* Holds prior fitness values - useful
				   for avoiding evaluation of individuals */
double v2[MAX_POP];		/* Holds prior fitness values - useful
				   for avoiding evaluation of individuals */

int (*c)[MAX_BITS];		/* Current population pointer */
int (*o)[MAX_BITS];		/* Old population pointer */

double *c_value;               /* Current prior fitness value pointer */
double *o_value;               /* Old prior fitness value pointer */

int size;		       /* Current size of population */
int length;		       /* Current size of individual */
int gen_time;		       /* Number of generations */
int bit;		       /* The picked bit where mutation did NOT
			          occur in the last generation */
int bits;		       /* Total number of bits */
int evals;		       /* Number of evaluations done this trial */

int iteration;		       /* How many iterations of the GA so far */

int new_best;                  /* Set to 1 if we have a NEW best individual */

int max_generation;            /* The maximum number of generations to run */

int reevaluations;             /* The number of re-evaluated individuals */

double log_m_rate;	       /* log_m_rate = log(1.0 - MUTATION); */
double total_fitness;	       /* Total Fitness of everyone */
double total_best_fitness;     /* Total fitness of the best ever eval */
double total_computed_fitness; /* Total fitness of every eval'ed individual */
double best;		       /* Best individual seen so far */
double solution;               /* The actual solution to the problem */
double offline_perf;           /* The current offline performance */
double online_perf;            /* The current online performance */
double conv;                   /* The current population convergence */
