/************************************************************
;                                                           *
;  William M. Spears					    *
;  Navy Center for Applied Research in AI                   *
;  Naval Research Laboratory                                *
;                                                           *
;  This software is the property of the Department of the   *
;  Navy. Permission is hereby granted to copy all or any    *
;  part of this program for free distribution, however      *
;  this header is required on all copies.		    *
;                                                           *
; File: global.c                                            *
;************************************************************/

#include "header.h"

/* Initialize GA Variables */

void init_ga_variables (pop_size, len)
int pop_size, len;
{
   int jump();

   c = p1;
   o = p2;
   c_value = v1;
   o_value = v2;
   size = pop_size;
   length = len;
   gen_time = 0;
   log_m_rate = log(1.0 - MUTATION);
   bit = jump();
   bits = size * length;
   total_fitness = 0.0;
   total_best_fitness = 0.0;
   total_computed_fitness = 0.0;
   best = 0.0;
   evals = 0;
}

/* Initializes all GA array structures.*/

void reinit_arrays ()
{
   int i, j;

   for (i = 1; i <= length; i++) {
	b[i] = 0;
   }

   for (i = 1; i <= size; i++) {
	v1[i] = -1;
	v2[i] = -1;
	sh[i] = 0;
	f[i] = 0.0;
	for (j = 1; j <= length; j++) {
		p1[i][j] = 0;
		p2[i][j] = 0;
	}
   }
}

/* Initialize the population with random bits. */

void init_ga_population ()
{
   int i, j;
   int brand();

   printf("Randomly initializing population.\n");
   for (i = 1; i <= size; i++) {
	c_value[i] = -1.0;
	for (j = 1; j <= length; j++) {	c[i][j] = brand(); }
   }
}

/* After one attempt to use the GA algorithm, reinitialize everything
   and try again - this code reinitializes everything. */

void reinit_everything ()
{
   int jump();

   reinit_arrays();
   c = p1;
   o = p2;
   c_value = v1;
   o_value = v2;
   bit = jump();
   gen_time = 0;
   total_fitness = 0.0;
   total_best_fitness = 0.0;
   total_computed_fitness = 0.0;
   best = 0.0;
   init_ga_population();
}

/* Swap the two populations that c[] and o[] point to...*/

void swap_pops ()
{
   int (*temp)[MAX_BITS];
   double *tempv;

   temp = c;		/* Swap population array pointers */
   c = o;
   o = temp;

   tempv = c_value;	/* Swap value array pointers */
   c_value = o_value;
   o_value = tempv;
}

