/************************************************************
;                                                           *
;  William M. Spears					    *
;  Navy Center for Applied Research in AI                   *
;  Naval Research Laboratory                                *
;                                                           *
;  This software is the property of the Department of the   *
;  Navy. Permission is hereby granted to copy all or any    *
;  part of this program for free distribution, however      *
;  this header is required on all copies.		    *
;                                                           *
; File: geval.c                                             *
;************************************************************/

#include "header.h"

void store_best_individual (i)
int i;
{
	int j;

	for (j = 1; j <= length; j++) { b[j] = c[i][j];	}
}

/* Code for evaluation of an individual in the current population.
   Keep track of the best one seen so far. This version takes advantage
   of previously computed evaluations from the prior generation. If
   a flag is true, there is no need to re-evaluate the individual.
   Mutation and cross-over will set the flag to false, in which case
   re-evaluation must occur. Also, keep track of the number of
   evaluations that occur. This is a better indication of the
   the number of individuals searched (it would be better to maintain
   all individuals, but that would be space intensive!).*/

double geval (i, onlinefp, offlinefp, convergefp, bestfp, reevalfp)
int i;
FILE *onlinefp, *offlinefp, *convergefp, *bestfp, *reevalfp;
{
	double value;
	double compute_online_perf(), compute_offline_perf(), convergence();
	double myeval();

	value = c_value[i];
	if (value != -1.0) { return(value); }
	else {	value = (double)myeval(i);
		evals++;
		c_value[i] = value;
		if (value > best) {
		        new_best = 1;
			best = value;
			store_best_individual(i);
		}

		total_best_fitness = total_best_fitness + best;
		total_computed_fitness = total_computed_fitness + value;

		/* Output statistics. For now this
		   code is commented out to skip the statistics.
		   If you want statistics, remove the comment
		   symbols. Also see run.c. */

		/*
                if ((evals % 100) == 0) {
		  fprintf(onlinefp, "%f\n", compute_online_perf());
		  fprintf(offlinefp, "%f\n", compute_offline_perf());
		  fprintf(convergefp, "%f\n", convergence());
		  fprintf(bestfp, "%f\n", best);
		  fprintf(reevalfp, "%d\n", reevaluations);
		}
		*/
		return(value);
	}
}

