/************************************************************
;                                                           *
;  William M. Spears					    *
;  Navy Center for Applied Research in AI                   *
;  Naval Research Laboratory                                *
;                                                           *
;  This software is the property of the Department of the   *
;  Navy. Permission is hereby granted to copy all or any    *
;  part of this program for free distribution, however      *
;  this header is required on all copies.		    *
;                                                           *
; File: fitness.c                                           *
;************************************************************/

#include "header.h"

/* This version of the fitness calculation code uses a global
   average of prior fitnesses (produced by the function geval)
   to produce the proper scaling of values. This should work
   better than the current generation minimum. */

double global_average_fitness;
double average_fitness;

double compute_offline_perf ()
{
   return(total_best_fitness / (double)evals);
}

double compute_online_perf ()
{
   return(total_computed_fitness / (double)evals);
}

double compute_global_average ()
{
   return(total_fitness / (double)(size * gen_time));
}

/* Return scaled fitness. */

double compute_value (value)
double value;
{
   value = value - (global_average_fitness / 2.0);
   if (value > 0.0) { return(value); }
   else return(0.0);
}

/* Computes scaled fitness for everyone in the population and
   computes various global statistics. Also prints out any new
   best individual. */

void fitness (onlinefp, offlinefp, convergefp, bestfp, reevalfp)
FILE *onlinefp, *offlinefp, *convergefp, *bestfp, *reevalfp;
{
	int i;
	double value, sum;
	double geval(), compute_global_average();

	sum = 0.0;
	global_average_fitness = compute_global_average();
	for (i = 1; i <= size; i++) {
		value = geval(i, onlinefp, offlinefp,
			      convergefp, bestfp, reevalfp);
		total_fitness = value + total_fitness;
		value = compute_value(value);
		sum = sum + value;
		f[i] = value;
	}
	average_fitness = sum / (double)size;

	if (new_best) {
	  printf("\nThe best individual is ");
	  show_best_individual();
	  printf(" with score: %f\n", best);
	  new_best = 0;
	}
}

/* Convert the fitness values in f[] into partial sums of
   expected number of offspring in f[]. Useful for selection.
   Notice that f[size] is fixed at "size". Mathematically, this
   should happen if the partial sums are allowed to run all
   the way to the end. However, math errors in C can accumulate
   and actually produce rather large discrepancies (which can
   cause the select algorithm to attempt to access an array 1
   step out of bounds). This should fix that problem - although
   some slight bias may be introduced.*/

void offspring ()
{
	int i;
	double prior;

	prior = f[1] / average_fitness;
	f[1] = prior;
	for (i = 2; i < size; i++) {
		f[i] = (f[i] / average_fitness) + prior;
		prior = f[i];
	}
	f[size] = (double)size;
}
