/************************************************************
;                                                           *
;  William M. Spears					    *
;  Navy Center for Applied Research in AI                   *
;  Naval Research Laboratory                                *
;                                                           *
;  This software is the property of the Department of the   *
;  Navy. Permission is hereby granted to copy all or any    *
;  part of this program for free distribution, however      *
;  this header is required on all copies.		    *
;                                                           *
; File: conv.c                                              *
;************************************************************/

#include "header.h"

int reevaluations;

#define CONV .89

/* Report some statistics. */

void report()
{
   double compute_online_perf(), compute_offline_perf(), convergence();

   offline_perf = compute_offline_perf();
   online_perf  = compute_online_perf();
   conv = convergence();

   printf("Online Perf: %f, Offline Perf: %f, Best: %f\n",
	  online_perf, offline_perf, best);
   printf("Convergence: %f, Re-evaluations: %d\n", conv, reevaluations);
}

/* Return t iff the column is converged to one value by CONV percent.*/

int column_convergence (j)
int j;
{
   int i, temp;

   temp = 0;
   for (i = 1; i <= size; i++) { if (c[i][j] == 1) temp++; }

   if ((temp > (CONV * size)) || (temp < ((1.0 - CONV) * size))) return(1);
   else return(0);
}

/* Return amount of convergence. */

double convergence ()
{
   int j, temp;
   int column_convergence();

   temp = 0;
   for (j = 1; j <= length; j++) {
	if (column_convergence(j)) temp++;
   }
   return((double)temp / (double)length);
}

/* Return t iff CONV percent of the columns have converged.*/

int convergencep ()
{
   double convergence();

   if (convergence() > CONV) return(1);
   else return(0);
}
