/*
 * pendutil.c	Utility routines, mainly graphical, for the inverted pendulum
 *		demonstration.
 *
 * Copyright (c) Togai InfraLogic, Inc., 1989, 1990, 1991, 1992.
 * All rights reserved.
 *
 * $Header:   Z:/vcs/common/pendutil.c_v   1.0   13 Oct 1992 11:28:08   eah  $
 *
 * ------------------------------- Changes -----------------------------------
 * 10/13/92 eah (1) Split off from pendemo.c to cut down the size of that
 *		    module.
 */

#include <conio.h>
#include <graph.h>
#include <malloc.h>
#include <memory.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <tilcomp.h>

#include "pendemo.h"

#ifdef	NEC_PC
int text_mode = _GPSET;
#endif

/*
 * Compute space required for a bitmap, and allocate the bitmap.
 */

char huge *new_bitmap (x0, y0, x1, y1)
short x0;
short y0;
short x1;
short y1;
{
    char huge *bitmap;

    bitmap = halloc (1L, (size_t) _imagesize (x0, y0, x1, y1));

    if (bitmap == (char huge *) NULL) {
	closeup ();
	printf ("Out of memory.  Sorry.\n");
	exit (0);
    }

    return bitmap;
}

/*
 * Allocate, fill in, and return a bitmap containing a string.
 */

char huge *string_bitmap (text)
char *text;
{
    int width;
    int color;
    char huge *bitmap;

    width = strlen (text) * CHAR_WIDTH;

    bitmap = new_bitmap (0, 0, width - 1, CHAR_HEIGHT - 1);
    color = _getcolor ();
    _setcolor (BLACK);
    _rectangle (_GFILLINTERIOR, 0, 0, width - 1, CHAR_HEIGHT - 1);
    _setcolor (color);
    strat (1, 1, text);
    _getimage (0, 0, width - 1, CHAR_HEIGHT - 1, bitmap);

    return bitmap;
}

/*
 * Portably set the color for text that follows.
 */

void textcolor (color)
short color;
{
#ifdef	NEC_PC
    _setcolor (color);
#else
    _settextcolor (color);
#endif
}

/*
 * Swap the current visual and active pages...
 */

void swapvideopages ()
{
    visualPage = !visualPage;
    _setactivepage (visualPage);
    _setvisualpage (!visualPage);
}

/*
 *  Draw some text(text) at a given row,col on the screen
 */

void strat (row, col, text)
int row;
int col;
char text[];
{
#ifdef	NEC_PC
    draw_text (row, col, text);
#else
    _settextposition (row, col);
    _outtext (text);
#endif
}

/*
 *  Draw a text line(text) in the center of the line (row).
 */

void strcenter (row, text)
int row;
char text[];
{
#ifdef	NEC_PC
    draw_text (row, 40 - (strlen (text)/2), text);
#else
    _settextposition (row, 40 - (strlen (text)/2));
    _outtext (text);
#endif
}

#ifdef	NEC_PC

void textmode (mode)
int mode;
{
    text_mode = mode;
}

/*
 * Draw text into the GRAPHICS buffer at the specified character coordinates.
 * Note that the NEC PC does not do this for outtext - it puts the text in
 * a weird text overlay area.
 */

void draw_text (row, col, text)
int row;
int col;
char *text;
{
    int x;
    int y;

    x = (col - 1) * CHAR_WIDTH;
    y = (row - 1) * LINE_SPACE;

    while (*text) {
	_gputchar (x, y, *text++, text_mode);
	x += CHAR_WIDTH;
    }
}
#endif

/*
 * This routine is called to place a frame around a given window indexed by
 * the win parameter in the color (color).  The window box is used as a base
 * for the frame and then outset by 3 pixels to give the frame its thickness
 */

void frame (win, color)
int win;
int color;
{
    int i;
    struct window w;

    _setcolor (color);
    w = windows[win];

    for (i = 1; i < 4; i++)
	_rectangle (_GBORDER, w.horiz-i, w.vert-i, w.horiz+w.width+i, w.vert+w.height+i);
}

/*
 *  Fill the interior of a given window(win) with its interior color
 */

void paintinterior (win)
int win;
{
    struct window w;

    w = windows[win];
    _setcolor (w.interior);
    _rectangle (_GFILLINTERIOR, w.horiz, w.vert, w.horiz+w.width, w.vert+w.height);
}


void fillrect(l,t,r,b,fc,ic)
int l,t,r,b,fc,ic;
{
    _setcolor (fc);
    _rectangle (_GBORDER, l-1, t-1, r+1, b+1);
    _setcolor (ic);
    _rectangle (_GFILLINTERIOR, l, t, r, b);
}

/*
 * Set a point structure var with a given x,y
 */

void setpoint (point, x, y)
struct pointmember *point;
int x;
int y;
{
    point->vv = x;
    point->bv = y;
}

/*
 *  Move to a new point(pt) offset by horiz and vert so that it is relative
 *  to a particular windows viewport
 */

void movetopt (pt, horiz, vert)
struct pointmember *pt;
int horiz, vert;
{
    _moveto (horiz+pt->vv, vert-pt->bv);
}

/*
 *  Draw a line from the curren pen position to a new point (pt) offset by
 *  horiz and vert so that it is relative to a particular windows viewport
 */

void linetopt(pt,horiz,vert)
struct pointmember *pt;
int horiz, vert;
{
    _lineto (horiz+pt->vv, vert-pt->bv);
}

/*
 * Put a message up on the screen and then restore the screen to origional
 */

void message (str)
char str[];
{
    screensave = new_bitmap (140-3, 95-3, 480+3, 130+3);

    if (screensave == NULL) {
	printf ("Out of Memory");
	exit (1);
    }

    _getimage (140-3, 95-3, 480+3, 130+3, screensave);

    _setcolor (windows[messagewin].interior);
    _rectangle (_GFILLINTERIOR, 140-3, 95-3, 480+3, 130+3);
    frame (messagewin, GREEN);
    strat (8, (40- (int) (strlen (str)/2)), str);
    strat (9, 30, "Any Key To Continue");

    swapvideopages ();

    getch ();

    swapvideopages ();

    _putimage (140-3, 95-3, screensave, _GPSET);

    hfree ((void huge*) screensave);
}

void drawbar (val, x, y, w, h)
int val;
int x;
int y;
int w;
int h;
{
    int hw;
    int vd4;

    vd4=(int) (val / 3);

    if (vd4 > 31)
	vd4 = 31;

    if (vd4 < -31)
	vd4 = -31;

    hw = x + (w / 2);
    _setcolor (LTGRAY);
    _rectangle (_GFILLINTERIOR, x, y, x+w, y+h);
    _setcolor (BLUE);
    _rectangle (_GBORDER, x-1, y-1, x+w+1, y+h+1);
    _rectangle (_GBORDER, x-2, y-2, x+w+2, y+h+2);
    _setcolor (RED);
    _rectangle (_GFILLINTERIOR, hw ,y, hw+vd4, y+h);
    _setcolor (LTYELLOW);
    _moveto (hw+vd4, y);
    _lineto (hw+vd4, y+h);
}

/*
 *  Draw some text(text) at a given row,col sideways on the screen
 */

void sideways (x, y, str)
int x, y;
char str[];
{
    unsigned int i;
    char j[2];

    strcpy (j, " ");

    for (i = 0; i < strlen (str); i++) {
	j[0] = str[i];
	strat (x+i, y, j);
    }
}

/*
 * Initialize a given window(win) to the parameters passed
 */

void setwindow (win,h,v,w,s,c)
int win,h,v,w,s,c;
{
    windows[win].horiz	   = h;
    windows[win].vert	   = v;
    windows[win].width	   = w;
    windows[win].height    = s;
    windows[win].interior  = c;
}
