/*
 * pendemo.h	Public declarations for the inverted pendulum demonstration.
 *
 * Copyright (c) Togai InfraLogic, Inc. 1989, 1990, 1991, 1992.
 * All rights reserved.
 *
 * $Header:   Z:/vcs/common/pendemo.h_v   1.5   13 Oct 1992 11:43:38   eah  $
 * ------------------------------- Changes -----------------------------------
 * 10/13/92 eah (1) Updated for the split of pendemo.c.
 */

/*
 * basic stuff.
 */

#define TRUE      1
#define FALSE     0
#define debugon   FALSE

/*
 * color constants
 */

#define BLACK	    0
#define BLUE        1
#define GREEN       2
#define CYAN        3
#define RED         4
#define MAGENTA     5
#define BROWN       6
#define LTGRAY      7
#define GRAY        8
#define LTBLUE      9
#define LTGREEN     10
#define LTCYAN      11
#define LTRED       12
#define LTMAGENTA   13
#define LTYELLOW    14
#define WHITE       15

/*
 * color constants for screen objects and modes
 */

#define mainscreen  LTCYAN
#define activewin   GREEN
#define inactivewin LTBLUE

#define mbfcurrent  GREEN
#define mbfview     MAGENTA
#define mbfclosed   BLACK
#define mbfoff	    RED
#define curmbf      LTGREEN
#define mbfdom      LTBLUE

#define pendbase    GRAY
#define pendframe   BLUE
#define pendmotor   CYAN
#define nobumpball  RED
#define bumpball    LTRED
#define pendstick   GREEN

#define logobox     WHITE
#define logoframe   LTBLUE

#define titletext   WHITE

/*
 * Variables and constants used for pendulum mechanics
 */

#define PI	    (3.14159265)
#define g	    (9.80665)
#define dT	    (0.04)
#define dT2	    (0.0016)

#define NM          4
#define NS          3
#define Z           2
#define PS          1
#define PM          0

#define Z_NM        1 
#define Z_NS        2 
#define Z_Z         0 
#define Z_PS        3 
#define Z_PM        4 
#define NM_Z        5 
#define NS_Z        6 
#define PS_Z        7 
#define PM_Z        8 
#define PS_NS	    9
#define NS_PS	    10

#define numrules    10

/*
 * Input keys
 */

#ifdef NEC_PC
#define F1	49
#define F2	50
#define F3	51
#define F4	52
#define F5	53
#define F6	54
#define F7	55
#define F8	56
#define F9	57
#define F10	48
#define SF5	37
#define SF6	38
#else
#define F1	49
#define F2	50
#define F3	51
#define F4	52
#define F5	53
#define F6	54
#define F7	55
#define F8	56
#define F9	57
#define F10	48
#define SF5	37
#define SF6	38
#endif

#ifdef	NEC_PC
#   undef   _GPSET
#   undef   _GPRESET
#   undef   _GAND
#   undef   _GXOR
#   undef   _GOR

#   define  _GOR	0x00
#   define  _GAND	0x01
#   define  _GPRESET	0x02
#   define  _GPSET	0x03
#   define  _GXOR	0x04

#   define  CHAR_WIDTH	8
#   define  CHAR_HEIGHT 16
#   define  LINE_SPACE	14	/* Really should be 16, but we need the space */
#else
#   define  CHAR_WIDTH	8
#   define  CHAR_HEIGHT 13
#   define  LINE_SPACE	12
#endif

/*
 * global structures
 */

struct pointmember {
    int vv;
    int bv;
};

struct rulelistelem {
    short open;
    short disabled;			    /* is the rule disabled */
    struct pointmember pointlists[3][5];    /* pointlists for the three */
    FUBYTE DOM; 			    /* Degree of membership */
    int thetaptr;
    int dthetaptr;
    int currentptr;
};

struct window {
    int horiz;				    /* Windows horizontal loc */
    int vert;				    /* Windows vertical loc */
    int width;				    /* Windows width in pixels */
    int height; 			    /* Windows height in pixels */
    int interior;			    /* Windows interior color */
};

/*
 * Public data
 */

extern int motorscalefactor;
extern int motorsize;			    /* Motor current output */
extern int motormax;			    /* Motor maximum limit */
extern int motormin;			    /* Motor minimum limit */
extern int motorstep;			    /* Motor increase/decrease step */
extern int motorsteps;

extern int sticksize;			    /* distance of the bob to pivot */
extern int stickfactor;
extern int sticktop;
extern int stickbottom;
extern short stickstop;

extern int bobmass;			    /* mass of the bob */
extern int bobmax;			    /* maximum mass of the bob */
extern int bobmin;
extern int bobstep;			    /* Bob increase/decrease step */
extern int bobsteps;
extern int bopthreshold;
extern int bopstartthresh;

extern int Error;			    /* Unscaled input to rulebase */
extern int dError;			    /* Unscaled input to rulebase */
extern int Current;			    /* Output from fuzzy rulebase */
extern SBYTE tempcurrent;		    /* scaled output for our system */
extern int lastError;
extern int lastdError;

extern int bopticks;
extern short animatebop;
extern short shooting;
extern short retractbopper;
extern short allowbopping;
extern int shotpos;
extern int extendbopper;
extern int bopperimpactpt;

extern int timelinedata[];		    /* Stored historical currents */
extern int timelinemax;

extern struct rulelistelem rulelist[];	    /* Rule list */
extern struct window windows[]; 	    /* Windows array */
extern int s4data[5][255];
extern int s6data[5][255];
extern short done;			    /* Program terminated flag */
extern short visualPage;		    /* Page flipping var */

extern int helpwin;			    /* help window index */
extern int timewin;			    /* time value window index */
extern int pendwin;			    /* pendulum window index */
extern int pickwin;			    /* pick list matrix index */
extern int currentwin;			    /* current window index */
extern int mbfwin;			    /* rule window index */
extern int titlewin;			    /* titlebar window index */
extern int messagewin;			    /* message window index */
extern int aboutwin;			    /* about window index */
extern int numwinopen;			    /* number of windows open */
extern int curmbfx;			    /* current matrix x index */
extern int curmbfy;			    /* current matrix y index */
extern int pendball;			    /* pendball var for flashing */
extern int curpage;			    /* Help current page */
extern int maxpage;			    /* Help maximun pages */
extern int currule;			    /* currently selected rule */
extern int oldrule;			    /* previously selected rule */
extern int ruletodisable;		    /* rule that will be disabled */

extern char title1[];
extern char title2[];
extern char title3[];

extern char huge *helpmaps[];
extern char huge *rulemaps[];		    /* Rule text images 	*/
extern char huge *miscmaps[];
extern char huge *screensave;		    /* Screen buffer for info	*/
extern char huge *helpedwin;		    /* Screen buffer for help	*/
extern char huge *titlebarmap[];	    /* Screen buffer for title	*/
extern char huge *minstrmap;		    /* Screen buffer for minstr */

extern UBYTE *errorlist[];
extern UBYTE *derrorlist[];
extern char listnames[5][3];

extern float Inertia;			    /* sticksize ** 2 * bobmass */
extern float Theta;			    /* actual scaled bob angle */
extern float DesiredTheta;		    /* desired bob angle PI/2 */
extern float Omega;			    /* actual scaled bob angular vel. */
extern float Alpha;			    /* actual bob angular acceleration */
extern float I; 			    /* real unscaled Current -1 to 1 */
extern float limitLeft; 		    /* Left pendulum limiter PI */
extern float limitRight;		    /* Right pendulum limiter 0 */

#ifdef TRACE
extern FILE *output_fp;
#endif

#ifdef FC110
extern int fc110;
#endif

/*
 * Subroutine prototypes.
 */

/* found in pendemo.c */

void main (void);
void initialize (void);
void checkkeyboard (void);
void initializeDisplay (void);
void initializeScreen (void);
void updateDisplay (void);
void updatePendulum (void);

#ifdef	FC110
void get_alphas (void);
#endif

void showabout (void);
/* void drawsmallmembval (int, int, int, UBYTE[]); */
void initMbfpoints (void);
void defineMBFpoints (int, int, int, int);
void buildlist (int, int, UBYTE[]);
void buildscaleddata (int, UBYTE[]);
void mbfdisable (void);
void showhelp (void);
void helppage (int);
void scaleerrors (void);
void cyclesystem (SBYTE);
void closeup (void);
int  findelem (int, int);

/* found in penddraw.c */

void drawActiveRules (void);
void updateTimeLine (void);
void openwindow (int);
void initcurrentwin (int);
void initmbfwin (int);
void drawpendulum (int, double);
void drawcurrent (int);
void showscaledvar (int, int, int, int, int, int, int);
void drawbigmembval (int, int, int, int);
void drawrule (void);
void drawmbf (int, int, int, int, int);
void drawdom (int, int, int);
void updatecurmbf (int, int);
void drawtimeline (int);

#ifdef	FC110
void drawfc110mode (int);
#endif

void drawRuleMatrix (int);
void fillMatrixRule (int, int, int);
void createbitmaps (void);
void animateheading (void);

/* found in pendutil.c */

char huge *new_bitmap (short, short, short, short);
char huge *string_bitmap (char *);
void textcolor (short);
void swapvideopages (void);
void strat (int,int, char[]);
void strcenter (int, char[]);
#ifdef	NEC_PC
void textmode (int);
void draw_text (int, int, char *);
#endif
void frame (int, int);
void paintinterior (int);
void fillrect (int, int, int, int, int, int);
void setpoint (struct pointmember *, int, int);
void movetopt (struct pointmember *, int, int);
void linetopt (struct pointmember *, int, int);
void message (char[]);
void drawbar (int, int, int, int, int);
void sideways (int, int, char[]);
void setwindow (int, int, int, int, int, int);
