/*
 * Copyright (c) 1992 The University of Utah and
 * the Center for Software Science (CSS).  All rights reserved.
 *
 * Permission to use, copy, modify and distribute this software is hereby
 * granted provided that (1) source code retains these copyright, permission,
 * and disclaimer notices, and (2) redistributions including binaries
 * reproduce the notices in supporting documentation, and (3) all advertising
 * materials mentioning features or use of this software display the following
 * acknowledgement: ``This product includes software developed by the Center
 * for Software Science at the University of Utah.''
 *
 * THE UNIVERSITY OF UTAH AND CSS ALLOW FREE USE OF THIS SOFTWARE IN ITS "AS
 * IS" CONDITION.  THE UNIVERSITY OF UTAH AND CSS DISCLAIM ANY LIABILITY OF
 * ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * CSS requests users of this software to return to css-dist@cs.utah.edu any
 * improvements that they make and grant CSS redistribution rights.
 *
 *      Utah $Hdr$
 *      Author: Doug Orr, University of Utah CSS
 */

#ifndef	_member_h_
#define	_member_h_	 1

/*  member:  describe membership of a fuzzy value within a fuzzy set  */

#include "degree.h"


template<class C> class member {
	char * n;

    public:
	member (char * n_) : n(n_)				{}
	virtual ~member ();

	char * 			name ()	const			{ return n ? n : "<none>"; }
	virtual degree 		is (const C value) const	= 0;
};

template<class C>
member<C>::~member ()
{
	if (n) delete [] n;
}

#endif	/* _member_h_ */
