/*
 * Copyright (c) 1992 The University of Utah and
 * the Center for Software Science (CSS).  All rights reserved.
 *
 * Permission to use, copy, modify and distribute this software is hereby
 * granted provided that (1) source code retains these copyright, permission,
 * and disclaimer notices, and (2) redistributions including binaries
 * reproduce the notices in supporting documentation, and (3) all advertising
 * materials mentioning features or use of this software display the following
 * acknowledgement: ``This product includes software developed by the Center
 * for Software Science at the University of Utah.''
 *
 * THE UNIVERSITY OF UTAH AND CSS ALLOW FREE USE OF THIS SOFTWARE IN ITS "AS
 * IS" CONDITION.  THE UNIVERSITY OF UTAH AND CSS DISCLAIM ANY LIABILITY OF
 * ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * CSS requests users of this software to return to css-dist@cs.utah.edu any
 * improvements that they make and grant CSS redistribution rights.
 *
 *      Utah $Hdr: geom_member.h 1.2 93/09/07$
 *      Author: Doug Orr, University of Utah CSS
 */

#ifndef	_geom_member_h_
#define	_geom_member_h_	 1

/*  geom_member:  "geometric" membership functions.
    trapezoidal or triangular membership functions... */

#include "member.h"

template<class C> 
class geom_member : public member<C> 
{

    public:
	geom_member (char * n_) : member<C> (n_)		{}
	virtual ~geom_member ();

	virtual degree		is (const C value) const	= 0;
	virtual C		output (const degree d) const	= 0;

	virtual C		area () const			= 0;
	virtual C		centroid () const		= 0;
	virtual C		moment () const			= 0;

	/* return a new membership function representing
	   the current function scaled to a given degree */
	virtual geom_member<C> * scale (const degree d) const 	= 0;

	/* return a new membership function representing
	   the current function clipped to a given degree */
	virtual geom_member<C> * clip (const degree d) const 	= 0;

};

template<class C>
geom_member<C>::~geom_member ()
{
}

#endif	/* _geom_member_h_ */
