/*
 * Copyright (c) 1992 The University of Utah and
 * the Center for Software Science (CSS).  All rights reserved.
 *
 * Permission to use, copy, modify and distribute this software is hereby
 * granted provided that (1) source code retains these copyright, permission,
 * and disclaimer notices, and (2) redistributions including binaries
 * reproduce the notices in supporting documentation, and (3) all advertising
 * materials mentioning features or use of this software display the following
 * acknowledgement: ``This product includes software developed by the Center
 * for Software Science at the University of Utah.''
 *
 * THE UNIVERSITY OF UTAH AND CSS ALLOW FREE USE OF THIS SOFTWARE IN ITS "AS
 * IS" CONDITION.  THE UNIVERSITY OF UTAH AND CSS DISCLAIM ANY LIABILITY OF
 * ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * CSS requests users of this software to return to css-dist@cs.utah.edu any
 * improvements that they make and grant CSS redistribution rights.
 *
 *      Utah $Hdr: famtest.C 1.8 93/09/07$
 *      Author: Doug Orr, University of Utah CSS
 */

#include <stdio.h>
#include "fuzzy.h"

#include "tri_member.h"
#include "trap_member.h"

#include "fam.h"
#include "fam_surf.h"

fuzzy<int> doug_height (72);		/* doug gets a height of 72' */
fuzzy<float> doug_temp(100.5);		/* doug has a fever of 99.5 % */

/* define triangular membership functions for ranges of height 
   and temperature */

trap_member<int> TALL (48, 72, 96, 96, 1);
trap_member<int> SHORT (48, 48, 56, 96, 1);
tri_member<float> NORMAL_TEMP (92.0, 98.6, 106.333, 1.0);
trap_member<float> HIGH_TEMP (92.0, 103.0, 106.333, 106.33, 1.0);

/* output values */
tri_member<int> MEDIUM_DOSE (0, 10, 14, 1);
tri_member<int> HEAVY_DOSE (0, 14, 18, 1);

void famtest ();

main ()
{
	printf ("doug_temp: %f\n", (float)doug_temp);
	printf ("doug_height: %d\n", (int)doug_height);
	
	degree d = doug_height.is (TALL);
	degree e = doug_temp.is (NORMAL_TEMP);
	int max = d && e;
	int min = d || e;

	printf ("d=%d e=%d\n", (int)d, (int)e);
	printf ("d && e = %d  d || e = %d !e=%d\n", max, min, (int)!e);

	/* test again with a new value, certain to produce interesting
	   result */
	doug_height = 60;
	printf ("doug_height: %d d=%d\n", (int)doug_height, doug_height.is (TALL));

	famtest ();
}


trap_member<int> NM (-128, -128, -64, -32, 1, "NM");
tri_member<int> NS (-64, -32,  0,  1, "NS");
tri_member<int> Z  (-32,   0,  32, 1, "Z");
tri_member<int> PS (  0,  32,  64, 1, "PS");
trap_member<int> PM ( 32,  64, 127, 127, 1, "PM");



fam<int> pendemo(5,
	 &NM,	&NS,	&Z,	&PS,	&PM,

	 NULL,	NULL,	&PM,	NULL,	NULL,
	 NULL,	NULL,	&PS,	&NS,	NULL,
	 &PM,	&PS,	&Z,	&NS,	&NM,
	 NULL,	&PS,	&NS,	NULL,	NULL,
	 NULL,	NULL,	&NM,	NULL,	NULL
);

fam<int> p1(3,
&PM, 	&PS, 	&Z,

NULL,	&PS,	NULL,
&PM,	&PS,	&Z,
NULL,	&PS,	&Z);

fam<int> p2(3,
&PS, 	&PM, 	&Z,

NULL,	&PM,	NULL,
&PS,	&PM,	&Z,
NULL,	&PM,	&Z);

fam_surf<int> fs(3,
&PM, 	&PS, 	&Z,
&p1, 	&p2,	NULL);

void famtest ()
{
	fuzzy<int> theta(-30, "theta");
	fuzzy<int> dTheta(20, "dTheta");
	fuzzy<int> current(0, "current");

	printf ("NM area = ... %d\n", NM.area ()); 
	printf ("NM centroid = ... %d\n", NM.centroid ()); 

	printf ("NS area = ... %d\n", NS.area ()); 
	printf ("NS centroid = ... %d\n", NS.centroid ()); 

	printf ("Z area = ... %d\n", Z.area ()); 
	printf ("Z centroid = ... %d\n", Z.centroid ()); 

	printf ("PS area = ... %d\n", PS.area ()); 
	printf ("PS centroid = ... %d\n", PS.centroid ()); 

	printf ("PM area = ... %d\n", PM.area ()); 
	printf ("PM centroid = ... %d\n", PM.centroid ()); 

	printf ("pendemo: RULES...\n");
	pendemo.print_rules (theta, dTheta, current);

	printf ("fam_surface: RULES...\n");
	fuzzy<int> foo(0, "foo");
	fs.print_rules (foo, theta, dTheta, current);

	printf ("inverted pendulum demo: enter theta/dTheta\n");

	while (1) {
		int v;
		printf ("theta (eof to exit)= ");
		if (scanf ("%d", &v) <= 0)
			break;
		theta = v;
		printf ("dTheta= ");
		scanf ("%d", &v);
		dTheta = v;
		
		pendemo.apply (theta, dTheta, current);

		printf ("%d,%d -> %d\n", (int)theta, (int)dTheta, (int)current);
	}

}


