/*
 * Copyright (c) 1992 The University of Utah and
 * the Center for Software Science (CSS).  All rights reserved.
 *
 * Permission to use, copy, modify and distribute this software is hereby
 * granted provided that (1) source code retains these copyright, permission,
 * and disclaimer notices, and (2) redistributions including binaries
 * reproduce the notices in supporting documentation, and (3) all advertising
 * materials mentioning features or use of this software display the following
 * acknowledgement: ``This product includes software developed by the Center
 * for Software Science at the University of Utah.''
 *
 * THE UNIVERSITY OF UTAH AND CSS ALLOW FREE USE OF THIS SOFTWARE IN ITS "AS
 * IS" CONDITION.  THE UNIVERSITY OF UTAH AND CSS DISCLAIM ANY LIABILITY OF
 * ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * CSS requests users of this software to return to css-dist@cs.utah.edu any
 * improvements that they make and grant CSS redistribution rights.
 *
 *      Utah $Hdr$
 *      Author: Doug Orr, University of Utah CSS
 */

#ifndef	_fam_h_
#define	_fam_h_ 1

#include "gen.h"
#include "fuzzy.h"
#include "geom_member.h"

template<class C> struct fam_member{
	int i, j;	
	geom_member<C> * ir;		// the two...
	geom_member<C> * ic;		// ... input members
	geom_member<C> * r;		// the output member
	fam_member<C> *	next;  		// next rule to be fired

	fam_member (geom_member<C> * r_, int i_, int j_, geom_member<C> * * fns) :
		r(r_), 
		i(i_), j(j_), 
		ir(fns[i_]), ic(fns[j_]),
		next(NULL)		{}
};

template<class C> class fam {
	friend class fam_n;
	friend class fam_surf;
	
	int dim;
	geom_member<C> * * 	fns;		// the base member functions

	fam_member<C> * * 	matrix;       	// matrix of rules
	fam_member<C> * 	first_rule;	// threaded list of rules

    public:
	fam (int dim_, ...);

	fam_member<C> *	rules ()	{return first_rule;}

	/* for the defined set of rules, apply inputs
	   to outputs */
	void 		apply (const fuzzy<C> &,
			       const fuzzy<C> &,
			       fuzzy<C> &);

	void		print_rules (const fuzzy<C> &, const fuzzy<C> &, const fuzzy<C> &);
};


template<class C>
void fam<C>::print_rules (const fuzzy<C> & v1, const fuzzy<C> & v2, const fuzzy<C> & result)
{
	for (fam_member<C> * f = first_rule; f; f = f->next) {
		printf ("\tIF  %s IS %s  AND  %s IS %s  THEN  %s IS %s \n",
			v1.name (),
			f->ir->name (),
			v2.name (),
			f->ic->name (),
			result.name (),
			f->r->name ());
	}
}


#endif	/* _fam_h_ */
