/*
 * Copyright (c) 1992 The University of Utah and
 * the Center for Software Science (CSS).  All rights reserved.
 *
 * Permission to use, copy, modify and distribute this software is hereby
 * granted provided that (1) source code retains these copyright, permission,
 * and disclaimer notices, and (2) redistributions including binaries
 * reproduce the notices in supporting documentation, and (3) all advertising
 * materials mentioning features or use of this software display the following
 * acknowledgement: ``This product includes software developed by the Center
 * for Software Science at the University of Utah.''
 *
 * THE UNIVERSITY OF UTAH AND CSS ALLOW FREE USE OF THIS SOFTWARE IN ITS "AS
 * IS" CONDITION.  THE UNIVERSITY OF UTAH AND CSS DISCLAIM ANY LIABILITY OF
 * ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * CSS requests users of this software to return to css-dist@cs.utah.edu any
 * improvements that they make and grant CSS redistribution rights.
 *
 *      Utah $Hdr$
 *      Author: Doug Orr, University of Utah CSS
 */

#ifndef	_degree_h_
#define	_degree_h_ 1

/* degree:  the result of analysing the membership of a given element
   within a set.  ex.:   theta.is (MS)  =>
   			 degree to which theta is MS.  

   values are scaled integers [0,255] => [0.0,1.0]  */

#include "gen.h"

static const int DEGREE_MAX = 255;

class degree {
	unsigned char d;
    public:
	degree () 							{}

	/* ASSUME that if we get a constructor with a float value, it
	   is in the range [0.0,1.0]; convert it [0,255].
	   ASSUME that if we get a constructor with an int-compatible
	   value that it will be in the range [0,255].
	   BAD things will happen if we violate these assumptions... */

	degree (int d_) : d(d_)						{}
	degree (float percent) : d((int)(percent * DEGREE_MAX))		{}

			operator int () 		{return d;}
	
  	degree 		operator && (degree &);
	degree 		operator || (degree &);
	degree	 	operator ! ();
		
};


inline degree degree::operator && (degree & d2)
{
	return Min ((int)d, (int)d2);
}

inline degree degree::operator || (degree & d2)
{
	return Max ((int)d, (int)d2);
}

inline degree degree::operator ! ()
{
	return DEGREE_MAX - d;
}

#endif	/* _degree_h_ */
