/* NEFCON-I: an interactive system for realization of a neural fuzzy controller

   Copyright (C) 1994 

   Institut fuer Betriebssysteme und Rechnerverbund, Technische Universitaet
   Braunschweig, Bueltenweg 74/75, 38106 Braunschweig, Germany, 
   hereby disclaims all copyright interests in the program NEFCON-I 
   written by Hermann-Josef Diekgerdes and Roland Stellmach.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/



#ifndef regel_tafel_h
#define regel_tafel_h

#include <InterViews/monoglyph.h>

#include "lingvar.h"
#include "regel.h"
#include "nfclook.h"

#define MAXNAME 10

/*
 *------------------------------------------------------------------------------
 * Klasse : RegelBrowser
 * Zweck  : Darstellung von Regeln, wobei einzelne Regeln markiert werden
 *          koennen. Es besteht ausserdem die Moeglichkeit, mehrere RegelBrowser
 *          miteinander zu verbinden, was zur Folge hat, dass alle dieselben
 *          Regeln darstellen und markieren.
 *------------------------------------------------------------------------------
 */
class RegelBrowser
{
  public : RegelBrowser();
           virtual void zeig_regeln(const RegelBasis*) = 0;
           virtual void markiere(int nr) = 0;
           virtual int markiert() = 0;
           virtual Glyph* glyph() = 0;
           void anbinden(RegelBrowser*);
           RegelBrowser* angebunden();
  private: RegelBrowser* _angebunden;
};

inline RegelBrowser::RegelBrowser() { _angebunden = nil; }

inline void RegelBrowser::anbinden(RegelBrowser* rb) { _angebunden = rb; }

inline RegelBrowser* RegelBrowser::angebunden() { return _angebunden; }


/*
 *------------------------------------------------------------------------------
 * Klasse : RegelTafel
 * Zweck  : Eine der moeglichen Realisierungen eines RegelBrowsers. Die Regeln
 *          werden in einem NfcStrBrowser dargestellt.
 *------------------------------------------------------------------------------
 */
class SyntaxMaske;
class RegelMaske;

class RegelTafel : public RegelBrowser
{
  public : RegelTafel(const RegelBasis*, const LingVarSatz*);
           virtual void zeig_regeln(const RegelBasis*);
           virtual void markiere(int nr);
           virtual int markiert();
           virtual Glyph* glyph();
  private: void _callback();
           NfcStrBrowser *_regel_tafel;
};


/*
 *------------------------------------------------------------------------------
 * Klasse : NumRegelEd
 * Zweck  : Regel koennen numerisch, d.h. per Tastatur, eingegeben werden. Zu
 *          diesem Zweck wurde die Klasse RegelTafel weiterentwickelt, indem
 *          Eingabefelder fuer die ling. Variablen hinzugefuegt wurden.
 *------------------------------------------------------------------------------
 */
class NumRegelEd : public RegelTafel
{
  public : NumRegelEd(NfcAusgabe*, RegelBasis*, LingVarSatz*);
           virtual void markiere(int nr);
           void markiere(Regel*);
           virtual Glyph* glyph();
           NfcAusgabe* ausgabe_feld;
  private: void _callback();
           void _loesch_regel_cb();            // Callback fuer 'loeschen'
           void _setz_regel_cb();              // Callback fuer 'setzen'
           void _reset_regel_cb();             // Callback fuer 'neu'
           int _regel_nr;
           boolean _lies_regel(Regel&);
           RegelBasis* _regelbasis;
           LingVarSatz* _lingvarsatz;
           SyntaxMaske* _syntax_maske;         // legt Regel-Syntax fest
           RegelMaske* _regel_maske;           // zum interaktiven Eingeben
           NfcKit* _nfc_kit;
           Glyph* _glyph;
};

inline Glyph* NumRegelEd::glyph() { return _glyph; }

#endif
