/* NEFCON-I: an interactive system for realization of a neural fuzzy controller

   Copyright (C) 1994 

   Institut fuer Betriebssysteme und Rechnerverbund, Technische Universitaet
   Braunschweig, Bueltenweg 74/75, 38106 Braunschweig, Germany, 
   hereby disclaims all copyright interests in the program NEFCON-I 
   written by Hermann-Josef Diekgerdes and Roland Stellmach.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/





#include <IV-look/kit.h>
#include <IV-look/menu.h>
#include <InterViews/layout.h>
#include <InterViews/session.h>
#include <InterViews/glyph.h>

#include "texte.h"
#include "global.h"
#include "regel_ed.h"

MenueStruktur RgEd_menue[] = {
  { 66, nil },                      // "beenden"
  { 67, nil },                      // "abbrechen"
  { -1 }
};

MenueStruktur RgEd_menue_bar[] = {
  { 65, nil, RgEd_menue, 3 },       // "fertig"
  { -1 }
};

/*
 *------------------------------------------------------------------------------
 *---------------------- Definition der Klasse : RegelEd -----------------------
 *------------------------------------------------------------------------------
 */

RegelEd::RegelEd(const LingVarSatz* lingvarsatz,
                 const RegelBasis* regelbasis,
                 Action* ende_cb,
                 Action* abbruch_cb)
  : NfcDialogFenster(nil)
{
  _lingvarsatz = *lingvarsatz;
  if(regelbasis == nil)               // keine Regeln vorgegeben
    _regelbasis = RegelBasis();
  else                                // vorgegebene Regeln uebernehmen
    _regelbasis  = *regelbasis;

  NfcAusgabe* ausgabe_feld = new NfcAusgabe(new AusgabeFeld(15, 6));
  _regel_browser1 = new NumRegelEd(ausgabe_feld, &_regelbasis, &_lingvarsatz);
  _regel_browser2 = new GrafRegelEd(ausgabe_feld, &_regelbasis, &_lingvarsatz);
  _regel_browser1->anbinden(_regel_browser2);
  _regel_browser2->anbinden(_regel_browser1);

  LayoutKit* lkit = LayoutKit::instance();
  WidgetKit* wkit = WidgetKit::instance();
  NfcKit* nfc_kit = NfcKit::instance();

  // Callbacks fuer das Menue installieren
  RgEd_menue[0].cb = ende_cb;
  RgEd_menue[1].cb = abbruch_cb;
  Menu* menue_balken = nfc_kit->menue(RgEd_menue_bar, wkit, lkit);

  Coord rand = 10;
  body(lkit->vbox(
         lkit->vcenter(
             lkit->hbox(
               lkit->variable_span(menue_balken, 0, 0),
               lkit->hglue()
             )
         ),
         lkit->margin(
           lkit->vbox(
             _regel_browser1->glyph(),
             lkit->vglue(rand, 0, 0),
             _regel_browser2->glyph(),
             lkit->vglue(rand, 0, 0),
             nfc_kit->text_drauf(Txt(40), ausgabe_feld, true)
           ), rand, rand
         )
       )
  );

  _regel_browser1->zeig_regeln(&_regelbasis);
  _regel_browser2->zeig_regeln(&_regelbasis);
}

RegelEd::~RegelEd()
{
  delete _regel_browser1;
  delete _regel_browser2;
}

/*
 *------------------------------------------------------------------------------
 * Elementfunktion : RegelEd::regelbasis()
 * Rueckgabewert : liefert eingegebene RegelBasis zurueck.
 * Zweck : siehe Rueckgabewert.
 *------------------------------------------------------------------------------
 */
RegelBasis* RegelEd::regelbasis() { return &_regelbasis; }
