/* $RCSfile: truck.c,v $ $Date: 1993/08/05 03:51:54 $ $Revision: 1.8 $  */
/*                                                                      */
/* by G.K. Egan + A. Sekercioglu,                                       */    
/* The Laboratory for Concurrent Computing Systems,                     */  
/* Swinburne University of Technology, Melbourne, Australia             */
/* for correspondence: Ahmet Sekercioglu ( yas@swin.oz.au )             */

#include <stdio.h>
#include <stddef.h>
#include <stdlib.h>
#include <sys/types.h>
#include <math.h>

#include "hlnfs.h"
#include "flie.h"

#define extern /*extern*/
#include "truck.h"
#undef extern

#define COPYRIGHT  "Copyright (C) G.K. Egan + A. Sekercioglu 1993"

#define EPSILON    (double) 0.01   /* If the difference between the */
                                   /* desired value and the actual  */
                                   /* value of the state variables  */
                                   /* are less than EPSILON, we     */
                                   /* assume that goal is achieved. */

/* function-block wide global declarations: */
static char rcs_id[]="$Id: truck.c,v 1.8 1993/08/05 03:51:54 yas Exp $";

void InitModel( initial_state_file, LINK )
     FILE *initial_state_file;
     ModelVarsIdStruct *LINK;
{
# ifdef DEBUG
  printf( "InitModel...\n" );
  printf( "%s\n", rcs_id );
# endif
  fscanf( initial_state_file, "%lf", &Variables[LINK->x].CurrVal );
  fscanf( initial_state_file, "%lf", &Variables[LINK->phi].CurrVal );
}  /* InitModel */

void Model( LINK )
     ModelVarsIdStruct *LINK;
{
  int r = 5; /* Truck moves this many units in every iteration */
  double truck_angle_radians;

# ifdef DEBUG
  printf( "Model...\n" );
# endif
  Variables[LINK->phi].CurrVal = Variables[LINK->phi].CurrVal +
                                  Variables[LINK->theta].CurrVal;
  truck_angle_radians = 0.017453292 * ( Variables[LINK->phi].CurrVal );
  Variables[LINK->x].CurrVal = Variables[LINK->x].CurrVal + 
                                  r * cos( truck_angle_radians );
}  /* Model */

boolean GoalAchieved( LINK )
     ModelVarsIdStruct *LINK;
{
  double phi_diff;
  double x_diff;

# ifdef DEBUG
  printf( "GoalAchieved...\n" );
# endif
  phi_diff = fabs( Variables[LINK->phi].CurrVal - 90.0 );
  x_diff =  fabs ( Variables[LINK->x].CurrVal   - 50.0 );
  if ( ( phi_diff < EPSILON ) && ( x_diff < EPSILON ) ) {
    return ( TRUE );
  }
  else {
    return ( FALSE );
  } /* if */
}  /* GoalAchieved */


boolean IdentifyModelVariables( LINK )
     ModelVarsIdStruct *LINK;
{
# ifdef DEBUG
  printf( "IdentifyModelVariables...\n" );
# endif
  if ( ! ( FoundVar( "x                               ", 
		   &LINK->x ) ) ||
       ! ( FoundVar( "phi                             ", 
		   &LINK->phi ) ) ||
       ! ( FoundVar( "theta                           ", 
		   &LINK->theta ) ) ) {
    return ( FALSE );
  }
  else {
    printf( "Var id's are : %d\t%d\t%d\n", LINK->x, LINK->phi, LINK->theta );
    return ( TRUE );
  } /* if */
}  /* IdentifyModelVariables */






