function [dveryA] = very(dA)
%VERY: This function operate as a quantifier on matrix of fuzzy values
%      A, and will  returns the  membership  function  related to
%      'very A'.
%
%                       [veryA] = VERY(A)
%
%      See also MORELESS and NOT.


% FISMAT: Fuzzy Inference Systems toolbox for MATLAB
% (c) A. Lotfi, University of Queensland (Email: lotfia@s1.elec.uq.oz.au)
% 13-10-93
% The program has been tested on MATLAB version 4.1, Sun workstation.

if (max(max(dA)) > 1) | (min(min(dA)) < 0)
error('Grade of membership function should not be more than one or less than zero.')
end

dveryA=dA .^ 2;
