function y = sigmoid(x, a, c)

%SIGMOID: Sigmoidal membership function with two parameters a and c.
%       
%                       [Y] = SIGMOID(X, a, c)
%
%         Returns a matrix Y with the same size as X; each element 
%         of Y is a grade of membership. Defults value for a and c 
%         are 1 and 0 respectively.
%
%                    See also BELL_1, BELL_2, TRAPEZE and MF_PANEL.

%       Copyright (c) 1993 Jyh-Shing Roger Jang, U. C. Berkeley
%       jang@eecs.berkeley.edu
%       (Tested on Matlab version 4.0a, HP workstation)
%       Permission is granted to modify and re-distribute this code
%       in any manner as long as this notice is preserved.
%       All standard disclaimers apply.

% REVISION:

% FISMAT: Fuzzy Inference Systems toolbox for MATLAB
% (c) A. Lotfi, University of Queensland (Email: lotfia@s1.elec.uq.oz.au)
% 13-10-93
% The program has been tested on MATLAB version 4.1, Sun workstation.


if nargin < 3,c=0;end
if nargin < 2,a=1;end


y = 1 ./(1 + exp(-a*(x-c)));
