%DA_PANEL.M:  To be called from FISDEMO.M.

%       Copyright (c) 1993 Jyh-Shing Roger Jang, U. C. Berkeley
%       jang@eecs.berkeley.edu
%       (Tested on Matlab version 4.0a, HP workstation)
%       Permission is granted to modify and re-distribute this code
%       in any manner as long as this notice is preserved.
%       All standard disclaimers apply.
%       7-4-93.

% REVISION:
% FISMAT: Fuzzy Inference Systems toolbox for MATLAB
% (c) A. Lotfi, University of Queensland (Email: lotfia@s1.elec.uq.oz.au)
% 13-10-93
% The program has been tested on MATLAB version 4.1, Sun workstation.

echo on;
clc;
% This file shows how different types of membership functions change 
% their widths, centers and midpoing slopes as their three parameters 
% (a, b, c) changes.
%
% Note: This part of demonstration is incomplete. There are some more
% functions regarding Adaptive Membership Function Scheme (AMFS) that
% will be released later on.
echo off;


clf;
%set(gcf, 'position', [510 144 700 420]);
set(gcf,'units','normal','position',[.34 .55 .65 .40]);

axes('units','normal','position',[.22 .10 .76 .82]);

X = (-10:0.1:10)';
% An arbitrary plot
plot_mf_d=plot(X,[0*X,0*X]);
axis([-10 10 0 1]);
% To initialize the xlabel and title field of current axes
xlabel(''); title('');
set(plot_mf_d,'erasemode','xor')
% If not initialized previously, t1 and t2 will be NULL
t1 = get(gca, 'xlabel'); set(t1, 'EraseMode', 'xor');
t2 = get(gca, 'title'); set(t2, 'EraseMode', 'xor');

  set(plot_mf_d(1), 'XData', X)
  set(plot_mf_d(2), 'XData', X,'color','r')


m_pos_x=.01;
m_pos_y=.60;
%Create frame for Mebership menu
mem_frame_d=uicontrol(gcf,'style','frame','units','normal',...
'position',[m_pos_x-.005 m_pos_y-.005 .17 .33]);

%text lables the radio menu
mem_txt_d=uicontrol(gcf,...
'style','text','units','normal',...
'position',[m_pos_x m_pos_y+.26 .16 .065],...
'string','Membership');
%Radio buttons that control setting

dance_mf_bell1=['for i=0:0.04:2,',...
        'a1 = 3*sin(i)+4;',...
        'b1 = 1+2*sin(i);',...
        'c1 = 5*cos(i);',...
        'y=bell_1(X,a1,b1,c1);',...
        'set(plot_mf_d(1), ''YData'', y),',...
        'a2 = 6*sin(i+pi/2);',...
        'b2 = 1+2*sin(i+pi/2);',...
        'c2 = 5*cos(i+pi/2);',...
        'y=bell_1(X,a2,b2,c2);',...
        'set(plot_mf_d(2), ''YData'', y);',...
        'text1 = sprintf(''yellow curve: (a, b, c) = (%6.2f, %6.2f, %6.2f)'', a1, b1, c1);',...
        'set(t1, ''string'', text1);',...
        'text2 = sprintf(''red curve: (a, b, c) = (%6.2f, %6.2f, %6.2f)'', a2, b2, c2);',...
        'set(t2, ''string'', text2);',...
        'drawnow,',...
	'end'];


mem_bell1_d = uicontrol(gcf,...
	'style','radio','units','normal',...
	'string','Bell_1',...
	'position',[m_pos_x m_pos_y+.195 .16 .065],...
	'value',1,...
	'hor','left',...
	'callback',[...
	'if get(mem_bell1_d,''value'') == 1 ,',...
	',set(mem_bell2_d,''value'' ,0),',...
	'set(mem_trapeze_d,''value'',0),',...
	'set(mem_sigmoid_d,''value'',0),',...
	'end,',dance_mf_bell1]);

dance_mf_bell2=['for i=0:0.02:1,',...
        'a1 = 3*sin(i)+4;',...
        'b1 = 1+2*sin(i);',...
        'c1 = 5*cos(i);',...
        'y=bell_2(X,a1,b1,c1);',...
        'set(plot_mf_d(1), ''YData'', y),',...
        'a2 = 6*sin(i+pi/2);',...
        'b2 = 1+2*sin(i+pi/2);',...
        'c2 = 5*cos(i+pi/2);',...
        'y=bell_2(X,a2,b2,c2);',...
        'set(plot_mf_d(2), ''YData'', y);',...
        'text1 = sprintf(''yellow curve: (a, b, c) = (%6.2f, %6.2f, %6.2f)'', a1, b1, c1);',...
        'set(t1, ''string'', text1);',...
        'text2 = sprintf(''red curve: (a, b, c) = (%6.2f, %6.2f, %6.2f)'', a2, b2, c2);',...
        'set(t2, ''string'', text2);',...
        'drawnow,',...
	'end'];

mem_bell2_d=uicontrol(gcf,...
	'style','radio','units','normal',...
	'string','Bell_2',...
	'position',[m_pos_x m_pos_y+.13 .16 .065],...
	'hor','left',...
	'callback',[...
	'if get(mem_bell2_d,''value'') == 1,',...
	',set(mem_bell1_d,''value'',0),',...
	'set(mem_trapeze_d,''value'',0),',...
	'set(mem_sigmoid_d,''value'',0),',...
	'end,',dance_mf_bell2]);

dance_mf_trapeze=['for i=0:0.02:1,',...
        'a1 = sin(i);',...
        'b1 = 2*sin(i);',...
        'c1 = 5*cos(i);',...
        'y=trapeze(X,a1,b1,c1);',...
        'set(plot_mf_d(1), ''YData'', y),',...
        'a2 = 1.4*sin(i+pi/2);',...
        'b2 = 2*sin(i+pi/2);',...
        'c2 = 5*cos(i+pi/2);',...
        'y=trapeze(X,a2,b2,c2);',...
        'set(plot_mf_d(2), ''YData'', y);',...
        'text1 = sprintf(''yellow curve: (a, b, c) = (%6.2f, %6.2f, %6.2f)'', a1, b1, c1);',...
        'set(t1, ''string'', text1);',...
        'text2 = sprintf(''red curve: (a, b, c) = (%6.2f, %6.2f, %6.2f)'', a2, b2, c2);',...
        'set(t2, ''string'', text2);',...
        'drawnow,',...
	'end'];

mem_trapeze_d  = uicontrol(gcf,...
	'style','radio','units','normal',...
	'string','Trapozidal',...
	'position',[m_pos_x m_pos_y+.065 .16 .065],...
	'hor','left',...
	'callback',[...
	'if get(mem_trapeze_d,''value'') == 1 ,',...
	'set(mem_bell1_d,''value'',0),',...
	'set(mem_bell2_d,''value'',0),',...
	'set(mem_sigmoid_d,''value'',0),',...
	'end,',dance_mf_trapeze]);

dance_mf_sigmoid=['for i=0:0.04:2,',...
        'a1 = 4*sin(i);',...
        'c1 = 8*cos(i);',...
        'y=sigmoid(X,a1,c1);',...
        'set(plot_mf_d(1), ''YData'', y),',...
        'a2 = 4*sin(i+pi/2);',...
        'c2 = -8*cos(i+pi/2);',...
        'y=sigmoid(X,a2,c2);',...
        'set(plot_mf_d(2), ''YData'', y);',...
        'text1 = sprintf(''yellow curve: (a, b, c) = (%6.2f, %6.2f, %6.2f)'', a1, b1, c1);',...
        'set(t1, ''string'', text1);',...
        'text2 = sprintf(''red curve: (a, b, c) = (%6.2f, %6.2f, %6.2f)'', a2, b2, c2);',...
        'set(t2, ''string'', text2);',...
        'drawnow,',...
	'end'];


mem_sigmoid_d=uicontrol(gcf,...
	'style','radio','units','normal',...
	'string','Sigmoid',...
	'position',[m_pos_x m_pos_y .16 .065],...
	'hor','left',...
	'callback',[...
	'if get(mem_sigmoid_d,''value'') == 1,',...
	'set(mem_bell1_d,''value'',0),',...
	'set(mem_bell2_d,''value'',0),',...
	'set(mem_trapeze_d,''value'',0),',...
	'end,',dance_mf_sigmoid]);

cl_close_d = uicontrol(gcf,'style','frame','units','normal',...
	'position',[.005 .095 .17 .075]);

% closing window push button
cl_close_dd = uicontrol(gcf,...
	'style','push','units','normal',...
	'string','Close Window','fore','r',...
	'position',[.01 .1 .16 .065],...
	'callback',['close(gcf),',...
	'clear m_pos_x m_pos_y t1 t2 plot_mf_d text2 text1 mem_frame_d a1 b1 c1 a2 b2 c2 ',...
	'mem_frame_d mem_txt_d dance_mf_bell1 mem_bell1_d dance_mf_bell2 mem_bell2_d ',...
	'dance_mf_sigmoid mem_sigmoid_d dance_mf_trapeze mem_trapeze_d cl_close_d ',...
	'cl_close_dd X y i ']);

eval(dance_mf_bell1);

