function y = bell_2(x, a, b, c)

% BELL_2: Generalized bell-shaped membership function with three
%         parameters a, b, c. (defaults are 1,1, and 0).
%         
%                        Y = BELL_2(X, a, b, c) 
%
%         Returns a matrix y with the same size as X; each element 
%         of Y is a grade of membership. Y=1/(1+(((X - c)/a)^2)^b);
%
%                    See also BELL_1, SIGMOID,TRAPEZE and MF_PANEL.

%       Copyright (c) 1993 Jyh-Shing Roger Jang, U. C. Berkeley
%       jang@eecs.berkeley.edu
%       (Tested on Matlab version 4.0a, HP workstation)
%       Permission is granted to modify and re-distribute this code
%       in any manner as long as this notice is preserved.
%       All standard disclaimers apply.
%       6-28-93.

% REVISION:

% FISMAT: Fuzzy Inference Systems toolbox for MATLAB
% (c) A. Lotfi, University of Queensland (Email: lotfia@s1.elec.uq.oz.au)
% 13-10-93
% The program has been tested on MATLAB version 4.1, Sun workstation.


if nargin < 4,c=0;end
if nargin < 3,b=1;end
if nargin < 2,a=1;end


[m n] = size(x);
x = x(:);
tmp = ((x - c)/a).^2;
tmp = tmp.^b;
y = ones(m*n,1)./(ones(m*n,1) + tmp);
y = reshape(y,m,n);
