function y = bell_1(x, a, b, c)

% BELL_1: Generalized bell-shaped membership function with  three 
%         parameters a, b, c. (Defaults are 1, 1, and 0 respectively).
%         
%                          Y=BELL_1(X, a, b, c)
%
%         Returns a matrix y with the same size as X; each element of 
%         Y is a grade of membership.Y=exp(-((((X -c)/a)^2)^b) );
%
% 	              See also BELL_2, SIGMOID, TRAPEZE and MF_PANEL.



% FISMAT: Fuzzy Inference Systems toolbox for MATLAB
% (c) A. Lotfi, University of Queensland (Email: lotfia@s1.elec.uq.oz.au)
% 13-10-93
% The program has been tested on MATLAB version 4.1, Sun workstation.



if nargin < 4,c=0;end
if nargin < 3,b=1;end
if nargin < 2,a=1;end

y=exp(-((((x -c) ./a) .^2) .^b) );
