function [W]=reason(a,b,c,d,e,f,g,h,i)
%REASON: This function manipulate the Max-Min for matrix of fuzzy value 
%        A and vector of observed value Ap. A and Ap must be defined 
%        over the same universe (the number of column of matrix A must 
%        be equal to length of vector Ap). The output W is Max-Min of
%	 observed value with each row of matrix A individually. 
% 
%         		[W] = REASON(A,Ap)
%
%        When premise contains more then one antecedent, Considering
%        liaison operator AND is important. Therefore if AND is 1, then
%        the minimum of two weight selected as overall weight of firing
%        and when it is 2 the multiplication considered. 
%
%        	 [W] = REASON(A1,A1p,...A4,A4p,AND)
%
%					See also SIMILAR and GRADEMF.

% FISMAT: Fuzzy Inference Systems toolbox for MATLAB
% (c) A. Lotfi, University of Queensland (Email: lotfia@s1.elec.uq.oz.au)
% 13-10-93
% The program has been tested on MATLAB version 4.1, Sun workstation.

if nargin ==  2

	W=cri(a',b);

elseif nargin == 5
	W1=cri(a',b); W2=cri(c',d);

	if e == 1
		W=min([W1(:),W2(:)]');
	elseif e == 2
		W=W1(:) .* W2(:);
	else
		error('Liasing operator AND is not a proper method.')
 	end

elseif nargin == 7
	W1=cri(a',b); W2=cri(c',d);W3=cri(e',f);

	if g == 1
		W=min([W1(:),W2(:),W3(:)]');
	elseif g == 2
		W=W1(:) .* W2(:) .* W3(:);
	else
		error('Liasing operator AND is not a proper method.')
	end

elseif nargin == 9
	W1=cri(a',b); W2=cri(c',d);W3=cri(e',f);W4=cri(g',h)

	if i == 1
		W=min([W1(:),W2(:),W3(:),W4(:)]');
	elseif i == 2
		W=W1(:) .* W2(:) .* W3(:) .* W4(:);
	else
		error('Liasing operator AND is not a proper method.')
	end


else
	error('Input arguments are not sufficient.');
end

W=W(:);
