function [dBp] = modify(dB,W,n)
%MODIFY: Consequence Modification: This function produce modified
%        consequent BMp, based on consequent matrix B and similarity 
%	 measure vector W. The method of modification N is selected 
%	 from the following list.
%
%                 		[BMp]=MODIFY(B,W,N)
%
%        1: Membership Value Reduction Form
%        2: More or Less Form
%
%					See also SIMILAR and TURKSEN.


% FISMAT: Fuzzy Inference Systems toolbox for MATLAB
% (c) A. Lotfi, University of Queensland (Email: lotfia@s1.elec.uq.oz.au)
% 13-10-93
% The program has been tested on MATLAB version 4.1, Sun workstation.

% consequence modification of invoked rule

if nargin < 3, n=1; end

%Membership Value Reduction Form


if n == 1
dBp=(diag(W)*ones(size(dB))) .* dB;

%More or Less Form

elseif n == 2,

dBp=min(1,(dB ./ (diag(W)*ones(size(dB)))));

else
error('Method of Consequence Modification is not correct')
end
end
