function [gmf]=grademf(A,Ao,u)
%GRADEMF: Grade of Membership Function: Consider a matrix of fuzzy
%         values A over universe of U. This function returns the grade
%         of membership function corresponding to each fuzzy sets
%         (Rows of matrix A) for observation nonfuzzy/crisp value Ao.
%
%                         [GMF] = GRADEMF(A,Ao,U)
%
%                                                See also SIMILAR. 
       

% FISMAT: Fuzzy Inference Systems toolbox for MATLAB
% (c) A. Lotfi, University of Queensland (Email: lotfia@s1.elec.uq.oz.au)
% 13-10-93
% The program has been tested on MATLAB version 4.1, Sun workstation.

if (Ao > max(u)) | (Ao < min(u) )
     	error('Observation value Ao must be in the range of universe U.')
end


if (max(max(A)) > 1) | (min(min(A)) < 0)
error('A: Grade of membership function should not be greater than one or less than zero.');
end
Ap=fzfir(5,u,0,0,Ao);
gmf=A(:,(find(Ap == 1)) );
