function [dBp] = cri(R,dAp)
%CRI:  Compositional Rule of Inference, based on fuzzy relation matrix
%      R and observation vector Ap, using Zadeh's inference CRI the
%      decision vector Bp is obtained.
%
%                        [Bp] = CRI(R,Ap)
%
%      Example: Suppose A and B are defied as:
%
%                   A=[1 .5 .1 0  0], B=[0  0 .1 .5 1]
%
%      Then fuzzy relation matrix R related to fuzzy implication A->B
%      is:(Mamdani implication relation)
%
%                          | 0  0  .1 .5  1 |
%                          | 0  0  .1 .5 .5 |
%                        R=| 0  0  .1 .1 .1 |
%                          | 0  0   0  0  0 |
%                          | 0  0   0  0  0 |
%                             B --------->
%
%      Let the observation value be Ap=[0 0 1 0 0], the decision vector
%      returns Bp=[0  0 .1 .1 .1].
%                                                       See also IMPLY.


% FISMAT: Fuzzy Inference Systems toolbox for MATLAB
% (c) A. Lotfi, University of Queensland (Email: lotfia@s1.elec.uq.oz.au)
% 13-10-93
% The program has been tested on MATLAB version 4.1, Sun workstation.


dAp=dAp(:);
[m,n]=size(R);

if (max(max(R)) > 1) | (max(max(dAp)) > 1)
	error('Grade of membership function should not be more than one')
end


if m ~= length(dAp)
	error('Observation vector Ap and R should have proper dimension')
end

dBp=max(min(R,(diag(dAp)*ones(size(R)))));

