% CONTROL_DEMO: To be called from FISDEMO.M.

% FISMAT: Fuzzy Inference Systems toolbox for MATLAB
% (c) A. Lotfi, University of Queensland (Email: lotfia@s1.elec.uq.oz.au)
% 13-10-93
% The program has been tested on MATLAB version 4.1, Sun workstation.

echo on
load control_demo.mat
clc;
% To illustrate application of approximate reasoning methods in close
% loop control systems, truck backer-upper control system , inverted
% pendulum system and Fan Speed control are taken as test_bed.

% Backing a truck to a loading dock is a nonlinear control problem which
% can involve extensive computation time to steer the truck to a 
% prescribed loading zone. The dynamic of truck backer-upper is given 
% in truck.m file. The input of this function are position
% of truck (x,y in yard), azimuth angle (Phi) of truck and the steering
% angle of truck (Theta). The function will return the next state of
% system. 

% The range of variables for simulated truck and controllers are as follows;

X=[0:4:100];
Phi=[-90:10:270];
Theta=[-30:2:30];

pause % Press any key to continue
clc;
% Since we presuppose adequate clearance between the truck and the loading
% dock, state variable Y can be abandoned. Therefore the inputs of 
% controller are X and Phi.

% The control goal is to steer the truck from any initial position to 
% prespecified loading dock with a right azimuth angle (Phi_final=90) and
% coincided rear position. The steering angle Theta is the control action
% which is provided by the designed fuzzy  controller. 
 
% There are different control strategy for this control problem. In this
% demonstration we show that the truck control is possible only with 
% maximum 9 rules. 

[a1,b1,c1,a2,b2,c2,ahat,bhat,chat]=truck_rule_9;

[A1,A2,B]=rulebase(1,X,a1,b1,c1,1,Phi,a2,b2,c2,1,Theta,ahat,bhat,chat);

mfplot(A1,X,A2,Phi,B,Theta);
 
pause % Press any key to continue
clc;
% We can select any approximate reasoning methods explained earlier, 
% the method we are going to use here is MAMDANI.
% The initial state of truck must be given for running simulation. We can
% assume;

truck_state_0=[20,20,90]'  %[X_position, Y_position, Azimuth angle Phi]

%>> state=[];trst=truck_state_0;
%>> for i=1:100
%>> [fuzzy_decision]=mamdani(A1,trst(1),X,A2,trst(3),Phi,U2,B,1,1);
%>> steer_angle=defzfir(fuzzy_decision,Theta,1);
%>> trst=truck(trst,steer_angle);
%>> state=[state, trst];
%>> end

pause % Press any key to continue
clc
% The truck trajectory from three initial position has been shown. 
% Moreover the fuzzy decision and its defuzzified value are shown on 
% the smaller box. This tracking ability are related to Mamdani approach
% (Min-Max) and centroid defuzzification. 

%			Wait Please ........

echo off;
trst=truck_state_0;
state1=[];state2=[];state3=[];sangle1=[];sangle2=[];sangle3=[];

clf;set(gcf,'units','normal','position',[.44 .55 .55 .4])
truck_axes=axes('units','normal','position',[.3 .1 .6 .8]);
truck_plot=plot(0,0);
axis([0 100 0 100]);
set(gca,'xtick',[0 10 20 30 40 50 60 70 80 90 100])
xlabel('X position');ylabel('Y position');title('Loading dock');

set(truck_plot,'erasemode','none','linestyle','*','color','r')

deci_axes=axes('position',[.03,.1,.2,.2]);
deci_plot=plot(Theta,zeros(size(Theta)),0,0,'r*');
axis([-30 30 0 2]);set(deci_axes,'xtick',[-30 0 30],'ytick',[0 2]);
xlabel('Steering angle');title('Fuzzy Decision')
set(deci_plot,'erasemode','xor')

truck_state_0=[20,20,90]';  %[X_position, Y_position, Azimuth angle Phi]
text(20,20,'Initial Position');
trst=truck_state_0;state=[];

step=1;
while step < 300
state1=[state1,trst];
[fuzzy_decision]=mamdani(A1,trst(1),X,A2,trst(3),Phi,B,1,1);
steer_angle=defzfir(fuzzy_decision,Theta,1);

	set(deci_plot(1),'ydata',fuzzy_decision)
	set(deci_plot(2),'xdata',steer_angle)
	trst=truck(trst,steer_angle);
	if trst(2) >= 100
		step=301;	
	end

	set(truck_plot,'xdata',trst(1),'ydata',trst(2));
	drawnow
step=step+1;
end

set(truck_plot,'color','y')
truck_state_0=[80,30,120]';  
trst=truck_state_0;state=[];

step=1;
while step < 300
[fuzzy_decision]=mamdani(A1,trst(1),X,A2,trst(3),Phi,B,1,1);
steer_angle=defzfir(fuzzy_decision,Theta,1);

	set(deci_plot(1),'ydata',fuzzy_decision)
        set(deci_plot(2),'xdata',steer_angle)

	trst=truck(trst,steer_angle);
        if trst(2) >= 100
                step=301;
        end

        set(truck_plot,'xdata',trst(1),'ydata',trst(2));
        drawnow
step=step+1;
end
 
set(truck_plot,'color','g')
truck_state_0=[60,40,-90]';
trst=truck_state_0;state=[];

step=1;
while step < 300
[fuzzy_decision]=mamdani(A1,trst(1),X,A2,trst(3),Phi,B,1,1);
steer_angle=defzfir(fuzzy_decision,Theta,1);

	set(deci_plot(1),'ydata',fuzzy_decision)
        set(deci_plot(2),'xdata',steer_angle)

	trst=truck(trst,steer_angle);
        if trst(2) >= 100
                step=301;
        end

        set(truck_plot,'xdata',trst(1),'ydata',trst(2));
        drawnow
step=step+1;
end

echo on;

pause % Press any key to continue
clc;
% Calculated steering angle is a continuse variable in the universe of Theta.
% We may want to quantize this control action and then applying it to truck.
% The function that can quantize the variable with a quantum size Q.

%>> for i=1:100
%>> [fuzzy_decision]=mamdani(A1,trst(1),X,A2,trst(3),Phi,U2,B,1,1);
%>> steer_angle=defzfir(fuzzy_decision,Theta,1);
%>> steer_angle_q=quantize(steer_angle,2);
%>> trst=truck(trst,steer_angle_q);
%>> end

%			Wait Please ........

echo off;
trst=truck_state_0;
state1=[];state2=[];state3=[];sangle1=[];sangle2=[];sangle3=[];

clf;set(gcf,'units','normal','position',[.44 .55 .55 .4])
truck_axes=axes('units','normal','position',[.3 .1 .6 .8]);
truck_plot=plot(0,0);
axis([0 100 0 100]);
set(gca,'xtick',[0 10 20 30 40 50 60 70 80 90 100])
xlabel('X position');ylabel('Y position');title('Loading dock');

set(truck_plot,'erasemode','none','linestyle','*','color','r')

deci_axes=axes('position',[.03,.1,.2,.2]);
deci_plot=plot(Theta,zeros(size(Theta)),0,0,'r*');
axis([-30 30 0 2]);set(deci_axes,'xtick',[-30 0 30],'ytick',[0 2]);
xlabel('Steering angle');title('Fuzzy Decision')
set(deci_plot,'erasemode','xor')

truck_state_0=[20,20,90]';  %[X_position, Y_position, Azimuth angle Phi]
text(20,20,'Initial Position');
trst=truck_state_0;state=[];

step=1;
while step < 300
state1=[state1,trst];
[fuzzy_decision]=mamdani(A1,trst(1),X,A2,trst(3),Phi,B,1,1);
steer_angle=defzfir(fuzzy_decision,Theta,1);

	set(deci_plot(1),'ydata',fuzzy_decision)
	set(deci_plot(2),'xdata',steer_angle)
	trst=truck(trst,steer_angle);
	if trst(2) >= 100
		step=301;	
	end

	set(truck_plot,'xdata',trst(1),'ydata',trst(2));
	drawnow
step=step+1;
end

set(truck_plot,'color','y')
truck_state_0=[80,30,120]';  
trst=truck_state_0;state=[];

step=1;
while step < 300
[fuzzy_decision]=mamdani(A1,trst(1),X,A2,trst(3),Phi,B,1,1);
steer_angle=defzfir(fuzzy_decision,Theta,1);

	set(deci_plot(1),'ydata',fuzzy_decision)
        set(deci_plot(2),'xdata',steer_angle)

	trst=truck(trst,steer_angle);
        if trst(2) >= 100
                step=301;
        end

        set(truck_plot,'xdata',trst(1),'ydata',trst(2));
        drawnow
step=step+1;
end
 
set(truck_plot,'color','g')
truck_state_0=[60,40,-90]';
trst=truck_state_0;state=[];

step=1;
while step < 300
[fuzzy_decision]=mamdani(A1,trst(1),X,A2,trst(3),Phi,B,1,1);
steer_angle=defzfir(fuzzy_decision,Theta,1);

	set(deci_plot(1),'ydata',fuzzy_decision)
        set(deci_plot(2),'xdata',steer_angle)

	trst=truck(trst,steer_angle);
        if trst(2) >= 100
                step=301;
        end

        set(truck_plot,'xdata',trst(1),'ydata',trst(2));
        drawnow
step=step+1;
end

echo on;

pause % Press any key to continue
clc;
% To investigate the control strategy globally, we can construct the decision
% surface related to any fuzzy approximation method.


%			Wait Please .......
 

%>> [S_truck9]=controlsurf('mamdani',A1,X,A2,Phi,B,Theta,1,1);
clf;set(gcf,'units','normal','position',[.54 .55 .45 .4])
cont_surf=mesh(Phi,X,rot90(S_truck9));
xlabel('X Position');ylabel('Azimuth angle');zlabel('Steering angle');
title('Cnntrol Surface for Truck Backer-Upper Control   9 Rules')


pause % Press any key to continue
clc;
% Now we can compare the control performance with 9 rules and 36 rules
% as proposed by Kosko. 

[a1,b1,c1,a2,b2,c2,ahat,bhat,chat]=truck_rule_36;

[A1,A2,B]=rulebase(1,X,a1,b1,c1,1,Phi,a2,b2,c2,1,Theta,ahat,bhat,chat);

% The approximate reasoning that we are going to use in this part of
% demonstration is LARSEN. (The initial positions are as before) 

%>> state=[];trst=truck_state_0;
%>> for i=1:100
%>> [fuzzy_decision]=larsen(A1,trst(1),X,A2,trst(3),Phi,U2,B,1,1);
%>> steer_angle=defzfir(fuzzy_decision,Theta,1);
%>> trst=truck(trst,steer_angle);
%>> state=[state,trst];
%>> end

%                       Wait Please ........

echo off;
truck_state_0=[20,20,90]';  %[X_position, Y_position, Azimute angle Phi]

trst=truck_state_0;
state1=[];state2=[];state3=[];sangle1=[];sangle2=[];sangle3=[];

clf;set(gcf,'units','normal','position',[.44 .55 .55 .4])
truck_axes=axes('units','normal','position',[.3 .1 .6 .8]);
truck_plot=plot(0,0);
axis([0 100 0 100]);
set(gca,'xtick',[0 10 20 30 40 50 60 70 80 90 100])
xlabel('X position');ylabel('Y position');title('Loading dock');

set(truck_plot,'erasemode','none','linestyle','*','color','r')

deci_axes=axes('position',[.03,.1,.2,.2]);
deci_plot=plot(Theta,zeros(size(Theta)),0,0,'r*');
axis([-30 30 0 2]);set(deci_axes,'xtick',[-30 0 30],'ytick',[0 2]);
xlabel('Steering angle');title('Fuzzy Decision')
set(deci_plot,'erasemode','xor')

truck_state_0=[20,20,90]';  %[X_position, Y_position, Azimuth angle Phi]
text(20,20,'Initial Position');
trst=truck_state_0;state=[];

step=1;
while step < 300
[fuzzy_decision]=larsen(A1,trst(1),X,A2,trst(3),Phi,B,1,1);
steer_angle=defzfir(fuzzy_decision,Theta,1);

	set(deci_plot(1),'ydata',fuzzy_decision)
	set(deci_plot(2),'xdata',steer_angle)
	trst=truck(trst,steer_angle);
	if trst(2) >= 100
		step=301;	
	end

	set(truck_plot,'xdata',trst(1),'ydata',trst(2));
	drawnow
step=step+1;
end

set(truck_plot,'color','y')
truck_state_0=[80,30,120]';  
trst=truck_state_0;state=[];

step=1;
while step < 300
[fuzzy_decision]=larsen(A1,trst(1),X,A2,trst(3),Phi,B,1,1);
steer_angle=defzfir(fuzzy_decision,Theta,1);

	set(deci_plot(1),'ydata',fuzzy_decision)
        set(deci_plot(2),'xdata',steer_angle)

	trst=truck(trst,steer_angle);
        if trst(2) >= 100
                step=301;
        end

        set(truck_plot,'xdata',trst(1),'ydata',trst(2));
        drawnow
step=step+1;
end
 
set(truck_plot,'color','g')
truck_state_0=[60,40,-90]';
trst=truck_state_0;state=[];

step=1;
while step < 300
[fuzzy_decision]=larsen(A1,trst(1),X,A2,trst(3),Phi,B,1,1);
steer_angle=defzfir(fuzzy_decision,Theta,1);

	set(deci_plot(1),'ydata',fuzzy_decision)
        set(deci_plot(2),'xdata',steer_angle)

trst=truck(trst,steer_angle);
        if trst(2) >= 100
                step=301;
        end

        set(truck_plot,'xdata',trst(1),'ydata',trst(2));
        drawnow
step=step+1;
end

echo on;

pause % Press any key to continue
clc;
% To investigate the control strategy globally, we can construct the decision
% surface related to any fuzzy approximation method.


%			Wait Please .......
 

%>> [S_truck36]=controlsurf('larsen',A1,X,A2,Phi,B,Theta,1,1);
clf;set(gcf,'units','normal','position',[.54 .55 .45 .4])
cont_surf=mesh(Phi,X,rot90(S_truck36));
xlabel('X Position');ylabel('Azimuth angle');zlabel('Steering angle');
title('Control Surface for Truck Backer-Upper Control  36 Rules')

pause % Press any key to continue
clc;
% The next control problem which we are going to explain is Inverted Pendulum
% System. It is composed of a rigid pole and a cart on which the pole is hinged.
% The state of this system is given by the pole's angle and angular velocity
% and the cart's horixzontal position and velocity. The only available control
% action is to exert forces on the cart that push it to left or right.
% Let's assume the initial conditions of the system as follows;

% [cart position, cart velocity, pole angle , pole angular velocity]   
invpend_state_0=[-5,1,20,0]'
pause % Press any key to continue
clc;
% There are four independent states, Since our control goal is to balance the
% pole regardless the cart's position and velocity, hence only two states 
% (angular potion and angular velocity of pole) are relevant in this simulation.

% The universe of angular position Theta and angular velocity Theta_dot are
% chosen as follows; 

Theta=[-40:2:40];   
Theta_dot=[-100:5:100];

% The rules are given in "invpend_rule_4". It is to be noted that since we
% want to use SUGENO's method, the rules are given the same format.

[a1,b1,c1,a2,b2,c2,P]=invpend_rule_4;

[A1,A2]=rulebase(2,Theta,a1,b1,c1,2,Theta_dot,a2,b2,c2);

mfplot(A1,Theta,A2,Theta_dot)

pause % Press any key to continue
clc;
% The dynamic of inverted pendulum system  is given in invpend.m file. 
% The input of this function are position of cart, velocity of cart, pole
% angle, angular velocity of pole and control force. The function will 
% return the derivative of the state of system.

% The reasoning which we are going to use here is SUGENO. 

%>> state=invpend_state_0;
%>> for i=1:300
%>>
%>>     [force]=sugeno(A1,state(3),Theta,A2,state(4),Theta_dot,P,1);
%>>     [state_dot]=invpend(state,force);
%>>     state=state+ .01*state_dot;
%>>
%>> end
 
%                            Wait Please .....
echo off

x=invpend_state_0(1);
theta=invpend_state_0(3);

x_data=[x-3 x-3 x+3 x+3 x-3];
force_data_x=[x x+20*sin(theta)];
force_data_y=[8 8+20*cos(theta)];

clf;set(gcf,'units','normal','position',[.44 .55 .55 .4])
invpend_axes=axes('units','normal','position',[.3 .1 .65 .8]);
invpend_plot=plot(x_data,[4 8 8 4 4],force_data_x,force_data_y,'r',[-20,20],[2,2],'c');
axis([-20 20 0 40])
set(invpend_plot,'linewidth',5,'erasemod','xor')
set(invpend_plot(3),'linewidth',20)
set(invpend_axes,'ytick',[])
xlabel('X position');title('INVERTED PENDULUM SYSTEM');

theta_axes=axes('position',[.05,.1,.2,.2]);
theta_plot=plot(theta,0,'r-');
axis([0 3 -20 20]);
xlabel('Time (Sec.)');title('Pole angle')
set(theta_plot,'erasemode','none')

force_axes=axes('position',[.05,.7,.2,.2],'ytick',[-10 0 10]);
force_plot=plot(0,0,'g-');
axis([0 3 -10 10]);
xlabel('Time (Sec.)');title('Applied force')
set(force_plot,'erasemode','none')

state=invpend_state_0;
for i=1:300

	[force]=sugeno(A1,state(3),Theta,A2,state(4),Theta_dot,P,1);
	[state_dot]=invpend(state,force);
	state=state+ .01*state_dot;

	x_data=[state(1)-3 state(1)-3 state(1)+3 state(1)+3 state(1)-3];
	force_data_x=[state(1) state(1)+20*sin(state(3)*pi/180)];
	force_data_y=[8 8+20*cos(state(3)*pi/180)];

        set(invpend_plot(1),'xdata',x_data)
        set(invpend_plot(2),'xdata',force_data_x,'ydata',force_data_y)
	set(theta_plot,'xdata',i*.01,'ydata',state(3))
	set(force_plot,'xdata',i*.01,'ydata',force)
drawnow
end

echo on;

pause % Press any key to continue
clc;
% The control action surface related to two inputs ,pole angle and angular 
% velocity of pole, can be constructed as follows;


%                        Wait Please ......

%>> [S_invpend]=controlsurf('sugeno',A1,Theta,A2,Theta_dot,P,2);
clf;set(gcf,'units','normal','position',[.54 .55 .45 .4])
cont_surf=mesh(Theta,Theta_dot,S_invpend);
xlabel('Pole angle (degree)');ylabel('Angular velocity');
zlabel('Controller''s output force (newton)');
title('Control Surface for Inverted Pendulum System with 4 rules')

pause % Press any key to continue
clc;
% The third control problem which we are going to investigate is designed
% to control the temperature and humidity of a bathroom, where the ideal
% condition is "warm and dry", . The only parameter for control task is 
% fan speed. The universes considered for our simulation are; 

Tem=[40:2:120];   
Hum=[0:2:100];
Speed=[0:20:1000];

pause % Press any key to continue
clc;
% The fuzzy values for temperature, humidity and speed are defined as follows;

cool=trapeze(Tem,.05,30,45);
warm=trapeze(Tem,.05,0,80);
hot =trapeze(Tem,.05,30,115);

dry =trapeze(Hum,.04,30,10);
moist=trapeze(Hum,.04,0,50);
wet=trapeze(Hum,.04,30,90);

low=trapeze(Speed,.004,300,100);
med=trapeze(Speed,.004,0,500);
high=trapeze(Speed,.004,300,900);

pause % Press any key to continue
clc;
% The table of rules for control of fan speed can be taken as follows;
%
%                              TEMPERATURE
%
%                            COOL  WARM   HOT
%                           -----------------  
%                    DRY    | LOW | MED | MED                        
%                           -----------------
%      HUMIDITY      MOIST  | LOW | MED | HIGH                    
%                           -----------------
%                    WET    | MED | MED | HIGH     SPEED                        
%                                                                  

A1=[cool; warm; hot; cool;  warm;  hot;   cool; warm; hot];
A2=[dry;  dry;  dry; moist; moist; moist; wet;  wet;  wet];
B =[low;  med;  med; low;   med;   high;  med;  med;  high];


mfplot(A1,Tem,A2,Hum,B,Speed);

pause % Press any key to continue
clc;
% The control surface related to these membership functions and table of
% rules can be calculated.

%                      Wait Please .........

%>> [S_fan]=controlsurf('larsen',A1,Tem,A2,Hum,B,Speed,2,1); 
clf;set(gcf,'units','normal','position',[.54 .55 .45 .4])
cont_surf=mesh(Tem,Hum,S_fan);
xlabel('Temperature (F)');ylabel('Humidity (%)');
zlabel('Fan speed (rpm)');
title('Control Surface for Fan Speed Control')

pause % Press any key to continue
clc;
% Please move the sliders to see the effects of temperature and humidity 
% on speed of fan.

%>> Bp=larsen(A1,T,Tem,A2,H,Hum,B,2,1);
%>> Bo=defzfir(Bp,Speed,1);

echo off

clf;set(gcf,'units','normal','position',[.44 .55 .55 .4])

[Bp]=larsen(A1,50,Tem,A2,40,Hum,B,2,1);
Bo=defzfir(Bp,Speed,1);

set(subplot(221),'position',[.05 .58 .32 .34])
speed_plot=plot([Bo Bo Bo],[0 1 0],[0 250 500],[1 1 0],[250 500 750],[0 1 0],[500 750 1000],[0 1 1]);
axis([0 1000 0 1.2])
set(speed_plot,'erasemode','none')
set(speed_plot(1),'erasemode','background')
text([80 480 800],[1.1 1.1 1.1],['LOW ';'MED ';'HIGH'])
title('Fan Speed (rpm)')

set(subplot(223),'position',[.05 .11 .32 .34])
fan_plot=plot(Speed,Bp);
axis([0 1000 0 1.2])
set(fan_plot,'erasemode','xor')
text([80 480 800],[1.1 1.1 1.1],['LOW ';'MED ';'HIGH'])
title('Fan Speed (rpm)')

set(subplot(222),'position',[.44 .58 .32 .34])
tem_plot=plot([70 70 70],[0 1 0],[40 60 80],[1 1 0],[60 80 100],[0 1 0],[80 100  120],[0 1 1]);
axis([40 120 0 1.2]);
set(tem_plot,'erasemode','none')
set(tem_plot(1),'erasemode','background')
text([5 50 95],[1.1 1.1 1.1],['COOL';'WARM';'HOT '])
title('Temperature (F)')

set(subplot(224),'position',[.44 .11 .32 .34])
hum_plot=plot([40 40 40],[0 1 0],[0 25 50],[1 1 0],[25 50 75],[0 1 0],[50 75 100],[0 1 1]);
axis([0 100 0 1.2])
set(hum_plot,'erasemode','none')
set(hum_plot(1),'erasemode','background')
text([10 40 80],[1.1 1.1 1.1],['DRY  ';'MOIST';'WET  '])
title('Humidity (%)')

sli_back=['T=get(sli_vol_t,''value'');',...
        'H=get(sli_vol_h,''value'');',...
        'set(tem_plot(1),''xdata'',[T T T ]),',...
        'set(hum_plot(1),''xdata'',[ H H H]),',...
	'Bp=larsen(A1,T,Tem,A2,H,Hum,B,2,1);',...
	'Bo=defzfir(Bp,Speed,1);',...
	'set(speed_plot(1),''xdata'',[Bo Bo Bo]),',...
	'set(fan_plot,''ydata'',Bp),',...
	'drawnow'];

sli_vol_t=uicontrol(gcf,...
	'style','slider','units','normal',...
	'position',[.78 .82 .2 .06],...
	'value',70,'max',120,'min',40,...
	'callback',sli_back);

sli_txt_t1=uicontrol(gcf,'style','text',...
	'units','normal',...
	'string','0% .......................100%',...
	'position',[.78 .88 .2 .04]);
sli_txt_t2=uicontrol(gcf,'style','text',...
        'units','normal',...
        'string','Temperature Control',...
        'position',[.78 .76 .2 .04]);

sli_vol_h=uicontrol(gcf,...
        'style','slider','units','normal',...
        'position',[.78 .35 .2 .06 ],...
        'value',40,'max',100,'min',0,...
	'callback',sli_back);
sli_txt_h1=uicontrol(gcf,'style','text',...
        'units','normal',...
        'string','0% .......................100%',...
        'position',[.78 .41 .2 .04]);
sli_txt_h2=uicontrol(gcf,'style','text',...
        'units','normal',...
        'string','Humidity  Control',...
        'position',[.78 .29 .2 .04]);

cl_close_fr = uicontrol(gcf,'style','frame','units','normal',...
        'position',[.78 .1 .2 .08]);
% closing window push button
cl_close = uicontrol(gcf,...
        'style','push','units','normal',...
        'string','Close Window','fore','r',...
	'position',[.79 .11 .18 .06],...
        'callback',['close(gcf)']);

pause % Press any key to continue
echo on;
clc;
% In this part of demonstration the following functions are introduced.
%
%	CONTROLSURF, QUANTIZE
%	INVPEND, INVPEND_RULE_4
%	TRUCK, TRUCK_RULE_9, TRUCK_RULE_36

echo off
