//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: World.h,v 0.22 1994/07/22 09:21:52 cncl-adm Exp cncl-adm $
 *
 * Class: World --- replacement for GIST1 World
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 * 
 * As an exception to this rule you may use this template to generate
 * your own classes. This does not cause these classes to be covered by
 * the GNU Library General Public License. This exception does not
 * however invalidate any other reasons why the resulting program must be
 * covered by the GNU Library General Public License. 
 **EHEADER********************************************************************/

#ifndef __World_h
#define __World_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/Object.h>		// Base class

extern CNClassDesc CN_WORLD;	// Class World description

#include <CNCL/gist.h>


/*
 * The class World
 */

class World : public CNObject
{
  public:	/***** Constructors ******************************************/
    World() {}
    World(CNParam *param) {}

    World(Comm& comm,
	  float xmin, float xmax, float ymin, float ymax,
	  double starttime = 0);
    virtual ~World();

  public:	/***** Public interface **************************************/
    virtual void line(float x1, float y1, float x2, float y2);
    GISTWorld &world() { return *world_; };

  private:	/***** Internal private members ******************************/
    GISTWorld *world_;
    GISTObject *bobj;
    GISTPicture *bpic;

  public:	/***** Member functions required by CNCL *********************/
    virtual CNClassDesc class_desc() const	// CNClass description
    { return CN_WORLD; }
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    { return desc == CN_WORLD ? TRUE : CNObject::is_a(desc); }
        
    static World *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (World *)obj;
#   else
	return (World *)( !obj || obj->is_a(CN_WORLD)
	       ? obj : fatal_type(obj->class_desc(), CN_WORLD) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new World(param) : new World; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};

#endif /**__World_h**/
