//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: NegExp.h,v 0.22 1994/07/22 09:20:28 cncl-adm Exp cncl-adm $
 *
 * CNClass: CNNegExp --- Negative exponential distributed random numbers
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************
 * original Copyright:
 * -------------------
 * Copyright (C) 1988 Free Software Foundation
 *    written by Dirk Grunwald (grunwald@cs.uiuc.edu)
 * 
 * This file is part of the GNU C++ Library.  This library is free
 * software; you can redistribute it and/or modify it under the terms of
 * the GNU Library General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your
 * option) any later version.  This library is distributed in the hope
 * that it will be useful, but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU Library General Public License for more details.
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 **EHEADER********************************************************************/

#ifndef __NegExp_h
#define __NegExp_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/Random.h>		// Base class

extern CNClassDesc CN_NEGEXP;	// CNClass CNNegExp description


/*
 * The class CNNegExp
 */

class CNNegExp : public CNRandom
{
protected:
    double pMean;

public:
    double mean();
    double mean(double x);

    virtual double operator()();

    /***** Constructors ******************************************************/
public:
    CNNegExp(); 				// Default constructor
    CNNegExp(CNParam *param); 			// CNParam constructor
    CNNegExp(double xmean, CNRNG *gen);

    /***** Member functions required by CNCL *********************************/
public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_NEGEXP;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_NEGEXP ? TRUE : CNRandom::is_a(desc);
    };
        
    static CNNegExp *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNNegExp *)obj;
#   else
	return (CNNegExp *)( !obj || obj->is_a(CN_NEGEXP)
	       ? obj : fatal_type(obj->class_desc(), CN_NEGEXP) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNNegExp(param) : new CNNegExp; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};



inline CNNegExp::CNNegExp(double xmean, CNRNG *gen)
    : CNRandom(gen)
{
    pMean = xmean;
    assert(pMean>0);                    // this line added
}

inline double CNNegExp::mean() { return pMean; }

inline double CNNegExp::mean(double x)
{
    double t = pMean; 
    pMean = x;
    return t;
}

inline CNNegExp::CNNegExp()
	 : CNRandom((CNRNG*)NIL)
{
    pMean = 0;
}

inline CNNegExp::CNNegExp(CNParam *param) 
	 : CNRandom((CNRNG*)NIL)
{
    pMean = 0;
}


#endif /**__NegExp_h**/
