//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: EZDDiag.h,v 0.22 1994/07/22 09:21:19 cncl-adm Exp cncl-adm $
 *
 * Class: EZDDiag --- x-y diagram as an EZDObject
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#ifndef __EZDDiag_h
#define __EZDDiag_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/EZDObject.h>		// Base class

extern CNClassDesc CN_EZDDIAG;	// Class EZDDiag description


/*
 * The class EZDDiag
 */

class EZDDiag : public EZDObject
{
public:
    enum Style { DOT, LINE, HISTO };

public:	/***** Constructors ******************************************/
    EZDDiag()
	: EZDObject("diag", 0, 0), vals(NIL), valx(0),
	  valstyle(HISTO), color_draw(""), color_bar("red")
        { initialize( -1, -1, WIDTH, HEIGHT, STEP); }
    EZDDiag(CNParam *param)
	: EZDObject("diag", 0, 0), vals(NIL), valx(0),
	  valstyle(HISTO), color_draw(""), color_bar("red")
        { initialize( -1, -1, WIDTH, HEIGHT, STEP); }
    EZDDiag(int w, int h, Style s=LINE)
	: EZDObject("diag", 0, 0), vals(NIL), valx(0),
	  valstyle(s), color_draw(""), color_bar("red")
        { initialize( -1, -1, w, h, STEP); }
    EZDDiag(int w, int h, int x, int y, Style s=LINE)
	: EZDObject("diag", x, y), vals(NIL), valx(0),
	  valstyle(s), color_draw(""), color_bar("red")
        { initialize( -1, -1, w, h, STEP); }
    EZDDiag(const CNString &name, int w, int h, int x, int y, Style s=LINE)
	: EZDObject(name, x, y), vals(NIL), valx(0),
	  valstyle(s), color_draw(""), color_bar("red")
        { initialize( -1, -1, w, h, STEP); }
    EZDDiag(int w, int h, int x, int y, Style s, CNString cd, 
            CNString cb)
	: EZDObject("diag", x, y), vals(NIL), valx(0),
	  valstyle(s), color_draw(cd), color_bar(cb)
        { initialize( -1, -1, w, h, STEP); }
    EZDDiag(const CNString &name, int w, int h, int x, int y, Style s, 
            CNString cd, CNString cb)
	: EZDObject(name, x, y), vals(NIL), valx(0),
	  valstyle(s), color_draw(cd), color_bar(cb)
        { initialize( -1, -1, w, h, STEP); }
    ~EZDDiag();	
    

public:	/***** Public interface **************************************/
    void style(Style s);
    void set_color_draw(CNString c);
    void set_color_bar(CNString c);
    void add(int v);
    void clear();
    virtual void redraw();  
    void set_frame();
    
  private:	/***** Internal private members ******************************/
    enum { WIDTH=200, HEIGHT=100, STEP=1 };
    enum { SCROLL_STEP=40 };
    
    int width, height;			// Width, height of rectangle
    int *vals;				// Array of values
    int valx;				// Current x position
    int valstep;			// x pixel increment
    int valn;				// Max. # of values
    bool frame;                         // diagram with frame ?
    Style valstyle;			// Drawing style
    CNString color_draw;		// Color for drawing values
    CNString color_bar;                 // Color for drawing of negative values
    	
  
    void initialize(int x, int y, int w, int h, int s);
    void draw_value(int x);



  public:	/***** Member functions required by CNCL *********************/
    virtual CNClassDesc class_desc() const	// CNClass description
    { return CN_EZDDIAG; }
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    { return desc == CN_EZDDIAG ? TRUE : EZDObject::is_a(desc); }
        
    static EZDDiag *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (EZDDiag *)obj;
#   else
	return (EZDDiag *)( !obj || obj->is_a(CN_EZDDIAG)
	       ? obj : fatal_type(obj->class_desc(), CN_EZDDIAG) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new EZDDiag(param) : new EZDDiag; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};

#endif /**__EZDDiag_h**/
