#include "SDLSystem_DemonGame.h"
#include "SDLProcess_environment.h"

int main() {
    /* the event scheduler has to be created early cause the processes
       send an init signal to themselves upon creation (this models the
       transition from the state start [in SDL] to the first regular
       state). Every system (including the environment-"system") such
       needs a pointer to the scheduler.                                */
    CNEventScheduler Demon_sched;
    
    /* most SDL specifications interact with the environment. This is
       treated here as a special process which has to be defined by the 
       user. The environment also works as a connection between systems.
       Look out SDLProcess_environment.c for further information.      */ 
    CNSDLProcess *env_proc = new SDLProcess_environment("environment", NIL, 1);
    
    /* The class CNSDLEnvironment represents the environment as a system.
       In contrast to normal systems it has only one process (which is
       a parameter to the constructor) and is connected to one or more
       other systems directly (the number of other systems + 1 is the 
       first parameter).                                              */
    CNSDLEnvironment Demon_env( 2, env_proc, &Demon_sched );

    /* SDL uses channels to connect blocks with each other or the 
       environment. These channels have a random delay which can be
       specified for all channels at once in the systems constructor
       or later for every single channel. Here the first method is 
       used.                                                          */
    CNRNG *base = new CNFiboG;
    CNNormal ch_rnd(0.1,0.1,base);
    /* creating the system class means building up and initialising
       the whole system (channels, processes etc.). Since we can work
       with many systems at once every system has a number starting
       with 2 (number 1 is used as PId of the environment and sytem
       number of the environment).                                    */
    SDLSystem_DemonGame Demon_sys( 2, &Demon_sched, &ch_rnd );

    /* every system has to be installed to the environment. This allows
       at least indirect signal passing (via environment) between 
       different systems. The first parameter of install is the unique
       system number of the system to be installed.                   */
    Demon_env.install( 2, &Demon_sys ); 
    
    /* At last the simulation can be started. */ 
    Demon_sched.start();

    return 0;
}

