//:ts=3  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: Template.h,v 0.4 1993/01/13 15:59:13 mj Exp mj $
 *
 * CNClass: Job --- Job class for queuing tests
 *
 * $Log: Template.h,v $
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************/

#ifndef __Job_h
#define __Job_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/Object.h>		// Base class

#include <CNCL/SimTime.h>

extern CNClassDesc CN_JOB;	// CNClass Job description


/*
 * The class Job
 */

class Job : public CNObject
{
public:
  CNSimTime in;				// Time job put into queue
  CNSimTime start;			// Time start of service
  CNSimTime out;			   // Time end of service
  double length;           // packet length
    
private:

    /***** Constructors ******************************************************/
public:
  Job()               : in(0), start(0), out(0), length(0) {}
  Job(CNParam *param) : in(0), start(0), out(0), length(0) {}

    /***** Member functions required by CNCL *********************************/
public:
  virtual CNClassDesc class_desc() const	// CNClass description
    {
      return CN_JOB;
    };
            
  virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
      return desc == CN_JOB ? TRUE : CNObject::is_a(desc);
    };
        
    static Job *cast_from_object(CNObject *obj);// Safe type cast
    
    // CNObject creation
    static CNObject *new_object(CNParam *param = NIL);
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};


#endif /**__Job_h**/













