//:ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: Template.c,v 0.4 1993/01/13 15:59:13 mj Exp mj $
 *
 * CNClass: Job --- Job class for queuing tests
 *
 * $Log: Template.c,v $
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************/

#include "Job.h"



/***** Default I/O member function for CNCL classes **************************/

// CNNormal output
void Job::print(ostream &strm) const
{
    strm << "in=" << in << " start=" << start << " out=" << out << 
      " length=" << length << endl;
}

// Debug output
void Job::dump(ostream &strm) const
{
    strm << "Job { "
	 << "in=" << in << " start=" << start << " out=" << out << " length=" << length
	 << " }" << endl;
}



/***** CNCL stuff for type information and exemplar objects ******************/

// Describing object for class Job
static CNClass Job_desc("Job", "$Revision: 0.4 $", Job::new_object);

// "Type" for type checking functions
CNClassDesc CN_JOB = &Job_desc;



/***** Safe type casts *******************************************************/

Job *Job::cast_from_object(CNObject *obj)
{
    if(!test_flag(type_check))
      return (Job *)obj;
    if(obj->is_a(CN_JOB))
      return (Job *)obj;
    else
    {
      fatal(NIL, "Invalid type cast: ", obj->class_desc()->name(),
	      " -> Job");
      return NIL;
    }
}



/***** CNObject creation *******************************************************/

CNObject *Job::new_object(CNParam *param)
{
    return param ? new Job(param) : new Job;
}
