/*=============================================================================

 F U Z Z Y   A R T M A P  (1 9 9 1)                  CAS/CNS Boston University 

  ** written by Ah-Hwee Tan  **

  ** Documented Oct 18, 1991 **
  ** revised    Dec 26, 1991 **

=============================================================================*/

#include <malloc.h>
#include "ARTMAP.h"

int    *label, num_pats;
float  **dpt;

prepare_data ()
{
  int  i;
  char choice[1];

  load_dat ();

  printf ("\nNormalization is required if your data is not within 0 and 1.");
  printf ("\nDo you require data normalization (y/n) ? ");
  scanf ("%s", choice);
  printf ("\n");

  if (strcmp(choice,"y")==0 || strcmp(choice,"Y")==0 )
    normalize ();

  write_dat ();

  printf ("\n> Data preprocessing done.\n\n");

  for (i=0; i<num_pats; i++)
    free (dpt[i]);
  free (dpt);
  free (label);
}

load_dat ()
{
  int    i, j;
  FILE   *in;
  char   t_file[16];
  char   dummy[200];

  printf ("\nName of Raw Data File > ");
  scanf ("%s", t_file);
  in = fopen (t_file, "r");
  fscanf (in, "%d %d %d", &num_pats, &a_length, &b_length);

  dpt = (float **) malloc (sizeof(float *)*num_pats);
  for (i=0; i<num_pats; i++)
    dpt[i] = (float *) malloc (sizeof(float)*(a_length+b_length));
  label = (int *) malloc (sizeof(int)*num_pats);

  fgets (dummy, 200, in);

  for (i=0; i<num_pats; i++)
    {
      for (j=0; j<a_length; j++)
	fscanf (in, "%f", &dpt[i][j]);
      fscanf (in, "%d", &label[i]);

      for (j=0; j<b_length; j++)
	 dpt[i][j+a_length] = 0.0;
      dpt[i][label[i]+a_length] = 1.0;
    }
  fclose (in);
}      

write_dat ()
{
  int    i, j;
  FILE   *out;
  char   t_file[16];

  printf ("Name for Readily Processed Binary File > ");
  scanf ("%s", t_file);

  out = fopen (t_file, "wb");
/*  fwrite (&num_pats, sizeof(int), 1, out);
  fwrite (&a_length, sizeof(int), 1, out);
  fwrite (&b_length, sizeof(int), 1, out); */
  for (i=0; i<num_pats; i++)
    fwrite (dpt[i], sizeof(float), a_length+b_length, out);

  fclose (out);
}

normalize ()
{
  int  i, j;
  float max, min;

  for (j=0; j<a_length; j++)
    {
      max = -9999.0;
      min = 9999.0;
      for (i=0; i<num_pats; i++)
	if (dpt[i][j] != -1)
	  {
	  
	    if (dpt[i][j] > max)
	      max = dpt[i][j];
	    if (dpt[i][j] < min)
	      min = dpt[i][j];
	  }
      if (max == min)
	{
	  for (i=0; i<num_pats; i++)
	    if (dpt[i][j] != -1)
	      dpt[i][j] = 1.0;
	}
      else
	for (i=0; i<num_pats; i++)
	  if (dpt[i][j] != -1)
	    dpt[i][j] = (dpt[i][j]-min)/(max-min);
    }
}










