/*=============================================================================

 F U Z Z Y   A R T M A P  (1 9 9 1)                  CAS/CNS Boston University 

  ** written by Ah-Hwee Tan  **

  ** Documented Oct 18, 1991 **
  ** revised    Dec 26, 1991 **

=============================================================================*/

#include "ARTMAP.h"

void  create_net ()
{
    int i;

    printf ("\nThis train_net Option constructs a ARTMAP system from all\n");
    printf ("the patterns in a preprocessed binary file. The order of\n");
    printf ("training is determined by the parameter orderedSet.\n\n");

    open_files ();
    init_system ();
    read_parameters ();
    num_voters = 1;
    num_runs = 1;
    trace = 2;

    display_parameters ();

    if (network_loaded)
      {
	free_memory ();
	free_series_data ();
      }

    alloc_series_memory ();
    init_series ();

    for (i= 0; i < train_pats; i++)
      Index[i] = i;
    if (orderedSet == 0 || orderedSet == 2)
      setup_index (train_pats);
    
    num_category[ARTa] = 0;
    num_category[ARTb] = 0;
    alloc_memory ();
    network_loaded = TRUE;

    init_ARTMAP ();
    init_ARTs ();
    init_ARTB ();
    train_process ();

    printf ("...  Training completed\n\n");
    close_files ();
}

void  train_net ()
{
    int i;

    printf ("\nThis train_net Option incrementally trains an existing ARTMAP system\n");
    printf ("from all the patterns in a preprocessed binary file. The order of\n");
    printf ("training is determined by the parameter orderedSet.\n\n");

    if (!network_loaded)
      {
	printf ("Warning: A ARTMAP network is not loaded\n");
	printf ("Please use load net to load a stored ARTMAP or\n");
	printf ("       use create net to start a new ARTMAP\n\n");
	return;
      }

    open_files ();
    read_parameters ();
    num_voters = 1;
    num_runs = 1;
    trace = 2;
    display_parameters ();

    alloc_series_memory ();
    init_series ();

    for (i= 0; i < train_pats; i++)
      Index[i] = i;
    if (orderedSet == 0 || orderedSet == 2)
      setup_index (train_pats);
    
    train_process ();

    printf ("...  Training completed\n\n");
    close_files ();
}

void  test_net ()
{
    int i;

    printf ("\nThis test_net Option evaluates the ARTMAP system constructed\n");
    printf ("by the train_net option by taking the test patterns from a\n");
    printf ("preprocessed binary file.\n\n");

    open_files ();
    init_system ();
    read_parameters ();
    num_voters = 1;
    num_runs = 1;
    orderedSet = TRUE;
    display_parameters ();

    for (i= 0; i < test_pats; i++)
      Index[i] = i;

    init_series ();
    rho[ARTa] = min_arho;
    rho[ARTb] = brho;

    test_process ();
    printf ("... Testing completed.\n\n");
    close_files ();
}

void  benchmark ()
{
    int series_counter, i, v;

    printf ("\nThis Benchmarking Option takes training and test set,\n");
    printf ("all from a single preprocessed binary file. The selection\n");
    printf ("of training and test set and the order of training are\n");
    printf ("determined by the parameter orderedSet.\n\n");

    open_files ();
    init_system ();

    if (network_loaded)
      {
	free_memory ();
	free_series_data ();
      }

    read_parameters ();
    display_parameters ();
    
    /* allocate memory for series data */

    alloc_series_memory ();
    init_series ();


    /* determine number of data categories and their distribution */

    alloc_memory ();
    pre_scan_data ();

    for(series_counter=0; series_counter < num_runs; series_counter++)
      {
	printf ("RUN #%d\n\n", series_counter+1);

	for (i= 0; i < tot_pats; i++)
	  Index[i] = i;

	if (orderedSet==0)
	  setup_index (tot_pats);

	init_votes ();
	for (v=0; v<num_voters; v++)
	  {
	    if (trace > 0)
	      printf ("Voter %d :\n\n", v+1);
	    if (orderedSet == 0 || orderedSet == 2)
	      setup_index (train_pats);
	    num_category[ARTa] = 0;
	    num_category[ARTb] = 0;
	    alloc_memory ();
	    init_ARTMAP ();
	    init_ARTs ();
	    init_ARTB ();
	    process ();
	    free_memory ();
	    count_votes (v);
	  }	  
      }
    if (display_confusion_matrix)
      calculate_correlation_coeff ();
    print_series_data ();
    free_series_data ();
    network_loaded = FALSE;
    close_files ();
}

interactive ()
{
  int  choice, done;

  done = FALSE;
  network_loaded = FALSE;

  while (!done)
    {
      printf ("\nInteractive Mode Option :\n\n");
      printf ("\t1) Load Net\n");
      printf ("\t2) Create Net\n");
      printf ("\t3) Train Net\n");
      printf ("\t4) Analyze Net\n");
      printf ("\t5) Test Net\n");
      printf ("\t6) Save Net\n");
      printf ("\t9) Quit to Main\n\n");

      printf ("Your Choice > ");
      scanf ("%d", &choice);

      switch (choice)
	{
	case 1 : load_net ();
	  break;
	case 2 : create_net ();
	  break;
	case 3 : train_net ();
	  break;
	case 4 : analyze_net ();
	  break;
	case 5 : test_net ();
	  break;
	case 6 : save_net ();
	  break;
	case 9 : done = TRUE;
	  if (network_loaded)
	    {
	      free_memory ();
	      free_series_data ();
	    }
	  break;
	}
    }
}

main ()
{
  int  choice, done;

  printf ("\n");
  printf ("=========================================================================\n");
  printf (" FUZZY ARTMAP (1991)                           CAS/CNS Boston University\n");
  printf ("=========================================================================\n");

  done = FALSE;
  network_loaded = FALSE;

  while (!done)
    {
      printf ("\nOption :\n\n");
      printf ("\t1) Preprocessing\n");
      printf ("\t2) Benchmarking\n");
      printf ("\t3) Interactive Mode\n");
      printf ("\t9) Quit\n\n");

      printf ("Your Choice > ");
      scanf ("%d", &choice);

      switch (choice)
	{
	case 1 : prepare_data ();
	  break;
	case 2 : benchmark ();
	  break;
	case 3 : interactive ();
	  break;
	case 9 : done = TRUE;
	  if (network_loaded)
	    {
	      free_memory ();
	      free_series_data ();
	    }
	  break;
	}
    }
}










