/*=============================================================================

 F U Z Z Y   A R T M A P  (1 9 9 1)                  CAS/CNS Boston University 

  ** written by Ah-Hwee Tan  **

  ** Documented Oct 18, 1991 **
  ** revised    Dec 26, 1991 **

=============================================================================*/

#include <malloc.h>
#include "ARTMAP.h"

int    *label;
float  **dpt;

load_net ()
{
  int    i, j;
  FILE   *in;
  char   l_file[16];

  printf ("\nLoad from : ");
  scanf ("%s", l_file);
  in = fopen (l_file, "rb");

  read_parameters ();

  fread (num_att, sizeof(int), 2, in);
  fread (num_category, sizeof(int), 2, in);

  if (network_loaded)
    {
      free_memory ();
      free_series_data ();
    }
  alloc_memory ();
  alloc_series_memory ();
  network_loaded = TRUE;

  for (i=0; i<2; i++)
    {
      fread (committed[i], sizeof(int), num_category[i]+1, in);
      for (j=0; j<num_category[i]+1; j++)
	fread (dn[i][j], sizeof(float), num_att[i], in);
    }

  for (i=0; i<num_category[ARTa]+1; i++)
    fread (IAMI[i], sizeof(int), num_category[ARTb]+1, in);

  fread (confidence, sizeof(float), num_category[ARTa]+1, in);
  fread (makes_prediction, sizeof(int), num_category[ARTa]+1, in);
  
  fclose (in);
}      

save_net ()
{
  int    i, j;
  FILE   *out;
  char   s_file[16];

  printf ("\nSave to : ");
  scanf ("%s", s_file);
  out = fopen (s_file, "wb");

  fwrite (num_att, sizeof(int), 2, out);
  fwrite (num_category, sizeof(int), 2, out);

  for (i=0; i<2; i++)
    {
      fwrite (committed[i], sizeof(int), num_category[i]+1, out);
      for (j=0; j<num_category[i]+1; j++)
	fwrite (dn[i][j], sizeof(float), num_att[i], out);
    }

  for (i=0; i<num_category[ARTa]+1; i++)
    fwrite (IAMI[i], sizeof(int), num_category[ARTb]+1, out);

  fwrite (confidence, sizeof(float), num_category[ARTa]+1, out);
  fwrite (makes_prediction, sizeof(int), num_category[ARTa]+1, out);
  
  fclose (out);
}      




