/*=============================================================================

 F U Z Z Y   A R T M A P  (1 9 9 1)                  CAS/CNS Boston University 

  ** written by Ah-Hwee Tan  **

  ** Documented Oct 18, 1991 **
  ** revised    Dec 26, 1991 **

=============================================================================*/

#include <malloc.h>
#include "ARTMAP.h"

extern int    ART ();
extern int    ART1reset ();
extern float  choiceOrderFunction ();
extern float  matchFunction ();

int    *num_pattern_coded, num_transient_category;
int    *num_predict_right, *num_predict_wrong;
int    predict_category, desired_category;
float  *norm;
FILE   *sfp;

analyze_net ()
{
  init_system ();
  read_parameters ();
  num_voters = 1;
  num_runs = 1;
  orderedSet = TRUE;
  display_parameters ();

  num_pattern_coded = (int *) malloc(sizeof(int)*num_category[ARTa]);
  num_predict_right = (int *) malloc(sizeof(int)*num_category[ARTa]);
  num_predict_wrong = (int *) malloc(sizeof(int)*num_category[ARTa]);
  norm = (float *) malloc(sizeof(float)*num_category[ARTa]);

  calculate_norm ();
  analyze_coding ();
  analyze_predicting ();
  count_transient_categories ();
  write_stat_result ();

  free (num_pattern_coded);
  free (num_predict_right);
  free (num_predict_wrong);
  free (norm);
}

calculate_norm ()
{
  int  i, j;

  for (i=0; i<num_category[ARTa]; i++)
    {
      norm[i] = 0;
      for (j=0; j<num_att[ARTa]; j++)
	norm[i] += dn[ARTa][i][j];
    }
}

analyze_coding ()
{
  int  i, j, cat;
  char   s_file[16];

  printf ("\nAnalyzing Coding Statistics with Training Set ..\n");
  open_files ();
  printf ("\nAnalyzing net. Please wait ...\n");

  for (i=0; i<tot_pats; i++)
    Index[i] = i;

  for (i=0; i<num_category[ARTa]; i++)
    num_pattern_coded[i] = 0;

  for (i=0; i<train_pats; i++)
    {
      refresh_system();
      read_pattern (i);
      cat = ART (ARTa, TEST);
      num_pattern_coded[cat]++;
    }

  close_files ();
}

analyze_predicting ()
{
  int  i, j, cat;

  printf ("\nAnalyzing Predicting Statistics with Test Set ..\n");
  open_files ();
  printf ("\nAnalyzing net. Please wait ...\n");

  for (i=0; i<tot_pats; i++)
    Index[i] = i;
  
  for (i=0; i<num_category[ARTa]; i++)
    {
      num_predict_right[i] = 0;
      num_predict_wrong[i] = 0;
    }

  for (i=0; i<test_pats; i++)
    {
      refresh_system();
      read_pattern (i);
      predict_category = B_then_A (TEST, i);
      cat = ART (ARTa, TEST);
      desired_category = ART (ARTb,TEST);
      if (predict_category==desired_category)
	num_predict_right[cat]++;
      else
	num_predict_wrong[cat]++;
    }
  close_files ();
}

int  count_transient_categories ()
{
  int  i;

  num_transient_category = 0;
  for (i=0; i<num_category[ARTa]; i++)
    if (num_pattern_coded[i]==0)
      num_transient_category++;
}
  

write_stat_result ()
{
  int    i, j;
  char   s_file[16];

  printf ("\nWrite analysis result to > ");
  scanf ("%s", s_file);
  printf ("\n");

  sfp = fopen (s_file, "w");
  fprintf (sfp, "--------------------------------------------------------\n");
  fprintf (sfp, "Category ARTa\tCode\tNorm\tPredict\tCorrect\tWrong\n");
  fprintf (sfp, "--------------------------------------------------------\n");
  for (i=0; i<num_category[ARTa]; i++)
    fprintf (sfp, "  %d\t\t %d\t%1.2f\t %d\t %d\t %d\n",
	     i+1, num_pattern_coded[i], norm[i],
             num_predict_right[i]+num_predict_wrong[i],
             num_predict_right[i],num_predict_wrong[i]);
  fprintf (sfp, "\n\tTotal of %d transient categories.\n\n", num_transient_category+1);
  fprintf (sfp, "--------------------------------------------------------\n");


  fclose (sfp);
}







