;;; test the fuzzy functions for accessing fuzzy fact information
;;; checking errors in parameters and proper operation of functions
(clear)
(deftemplate temp
 0 100 DEGREES-C
 ((low (0 1) (10 0))
  (med (5 0) (50 1) (95 0))
 )
)
(deftemplate temp-nounits
 0 100
 ((low (0 1) (10 0))
  (med (5 0) (50 1) (95 0))
 )
)

;; access via the template name
(get-u       temp)
(get-u-from  temp)
(get-u-to    temp)
(get-u-units temp)
(get-u       temp-nounits)
(get-u-from  temp-nounits)
(get-u-to    temp-nounits)
(get-u-units temp-nounits)

;; incorrect name specified for get-u functions
(get-u abc)
(get-u-from asd)
(get-u-to abs)
(get-u-units asdf)
(get-u "string-not-allowed")

;; access via the fact specifier or fuzzy value variable
(assert (temp-nounits low))
(assert (temp med))
(facts)
(defrule temp-discourse
  ?t <- (temp ?)
  (temp-nounits ?fv)
=>
  (bind ?s (get-u-units ?fv))
  (printout t "units of the universe of discourse are: " ?s "[should be empty string]"  crlf)
  (bind ?s (get-u ?t))
  (printout t "limits of the universe of discourse are: " ?s crlf)
  (bind ?s (get-u-from ?t))
  (printout t "lower limit of the universe of discourse is: " ?s crlf)
  (bind ?s (get-u-to ?t))
  (printout t "upper limit of the universe of discourse is: " ?s crlf)
  (bind ?s (get-u-units ?t))
  (printout t "units of the universe of discourse are: " ?s crlf)
)
(defrule temp-set
  ?t <- (temp ?)
=>
  (bind ?s (get-fs ?t))
  (printout t "fuzzy set is: " ?s crlf)
  (bind ?n (get-fs-length ?t))
  (printout t "number of pairs in fuzzy set is: " ?n crlf)
  (bind ?x (get-fs-x ?t (- ?n 1)))
  (bind ?y (get-fs-y ?t (- ?n 1)))
  (printout t "last pair are: " ?x "," ?y crlf)
  (bind ?x (get-fs-x ?t 0))
  (bind ?y (get-fs-y ?t 0))
  (printout t "first pair are: " ?x "," ?y crlf)
)
(run)
(defrule out-range-low
  (temp ?t)
=>
  (bind ?n (get-fs-length ?t))
  (bind ?x (get-fs-x ?t (- ?n (+ ?n 1))))
  (bind ?y (get-fs-y ?t (- ?n (+ ?n 1))))
  (printout t "out of range low: " ?x "," ?y crlf)
)
(run)
(clear)
(deftemplate temp
 0 100 DEGREES-C
 ((low (0 1) (10 0))
  (med (5 0) (50 1) (95 0))
 )
)
(assert (temp med))
(defrule out-range-high
  ?t <- (temp ?)
=>
  (bind ?n (get-fs-length ?t))
  (bind ?x (get-fs-x ?t (+ ?n 1)))
  (bind ?y (get-fs-y ?t (+ ?n 1)))
  (printout t "out of range high: " ?x "," ?y crlf)
)
(run)

;; Tests for function get-fs-value
;;
;; first error calls
(clear)
(deftemplate temp
  0 100 C
  ( (low (10 1) (50 0))
    (ok  (20 0) (50 1) (80 0))
    (high (50 0) (90 1))
  )
)
(defglobal ?*fv* = 0)
(get-fs-value 2 25)     ;1st arg must reference a fuzzy value
(bind ?*fv* (create-fuzzy-value temp ok))
(get-fs-value ?*fv* ss) ; 2nd arg must be numeric
(get-fs-value ?*fv* -1) ; 2nd arg must be above low limit
(get-fs-value ?*fv* 101); 2nd arg must be below hi limit
;;
;; valid calls
;;
(get-fs-value ?*fv* 0)    ; expect 0.0 result
(get-fs-value ?*fv* 100)  ; expect 0.0 result
(get-fs-value ?*fv* 20)   ; expect 0.0 result
(get-fs-value ?*fv* 80)   ; expect 0.0 result
(get-fs-value ?*fv* 50)   ; expect 1.0 result
(get-fs-value ?*fv* 65)   ; expect 0.5 result
(get-fs-value ?*fv* 20.01); expect close to 0.0
(get-fs-value ?*fv* 50.01); expect close to 1.0
(defrule test-get-fs-value
  =>
    (bind ?f (assert (temp very ok)))
    (loop-for-count (?i 25 85)
        (printout t "Value at " ?i " is "
                     (get-fs-value ?f ?i) crlf)
    )
)
(reset)
(run) ; expect a set of values that cover very ok
(clear)

;; Tests for function get-fs-lv
;;
;; first some invalid calls
(clear)
(deftemplate temp
  0 100 C
  ( (low (10 1) (50 0))
    (ok  (20 0) (50 1) (80 0))
    (high (50 0) (90 1))
  )
)

(get-fs-lv)             ; must have 1 arg
(get-fs-lv temp 2)      ; no more than 1 arg
(get-fs-lv 2)           ; arg must be fuzzy fact id or fuzzy value
(get-fs-lv (assert (a))); arg must be fuzzy fact id or fuzzy value
(retract *)
;;
;; valid calls with fuzzy fact-id, fact-address and fuzzy-values
;;
(get-fs-lv (assert (temp high and not low)))
(retract *)
(reset)
(assert (temp very low or ok))
(get-fs-lv 1)
(retract *)
(get-fs-lv (create-fuzzy-value temp low or high))
(defrule test-get-fs-lv1
  (temp ?x & ok)
 =>
  (printout t "LV for the matched fact is '" (get-fs-lv ?x)
              "' should be 'slightly ok'" crlf)
)
(assert (temp slightly ok))
(run)
(retract *)
(deftemplate system
   (slot name)
   (slot t1 (type FUZZY-VALUE temp))
   (slot t2 (type FUZZY-VALUE temp))
)
(defrule test-get-fs-lv2
  ?f <- (system (name ?) (t1 ?) (t2 ?t2))
 =>
  (printout t "LV for the matched slot t1 is '"
              (get-fs-lv (get-fuzzy-slot ?f t1))
              "' should be 'not very ok'" crlf)
  (printout t "LV for the matched slot t2 is '"
              (get-fs-lv (get-fuzzy-slot ?f t2))
              "' should be 'below ok'" crlf)
)
(assert (system (name systemA) (t1 not very ok) (t2 below ok)))
(run)
(retract *)
(clear)

;; Tests for the create-fuzzy-value function
;;
;; first some invalid calls
(clear)
(deftemplate temp
  0 100 C
  ( (low (10 1) (50 0))
    (ok  (20 0) (50 1) (80 0))
    (high (50 0) (90 1))
  )
)
(deftemplate temp1
  0 100 C
  ( (low (10 1) (50 0))
    (ok  (20 0) (50 1) (80 0))
    (high (50 0) (90 1))
  )
)
(deftemplate test (slot a) (slot b))
(defglobal ?*t* = 0)
(create-fuzzy-value)          ; needs 1 arg + fuzzy value spec
(create-fuzzy-value 23)       ; needs 1 arg + fuzzy value spec
(create-fuzzy-value str 3.0)  ; 1st arg must be a fuzzy deft name
(create-fuzzy-value test 3.0) ; 1st arg must be a fuzzy deft name
(create-fuzzy-value temp)     ; need a fuzzy value spec
(create-fuzzy-value temp 2.0) ; need a valid fuzzy value spec
(create-fuzzy-value temp not) ; need a valid fuzzy value spec
(bind ?*t* (create-fuzzy-value temp not low))
(create-fuzzy-value temp ?*t*); need a valid fuzzy value spec (no vars)
;;
;; now some valid calls
;;
(plot-fuzzy-value t * nil nil (create-fuzzy-value temp ok))
(plot-fuzzy-value t * nil nil (create-fuzzy-value temp not low))
(plot-fuzzy-value t * nil nil
            (create-fuzzy-value temp ok and low))
(plot-fuzzy-value t * nil nil
            (create-fuzzy-value temp (pi 10 20)))
(plot-fuzzy-value t * nil nil
            (create-fuzzy-value temp
                 (5 1) (10 .8) (20 .7) (35 .5) (50 .2) (70 1)))
(clear)

;; Tests for the fuzzy-union, fuzzy-intersection and
;; fuzzy-modify functions
;;
;; first some invalid calls
(clear)
(deftemplate temp
  0 100 C
  ( (low (10 1) (50 0))
    (ok  (20 0) (50 1) (80 0))
    (high (50 0) (90 1))
  )
)
(deftemplate heat
  0 100 C
  ( (low (10 1) (50 0))
    (ok  (20 0) (50 1) (80 0))
    (high (50 0) (90 1))
  )
)
(fuzzy-union)
(fuzzy-union (create-fuzzy-value temp ok))
(fuzzy-union 23 (create-fuzzy-value temp ok))
(fuzzy-union (create-fuzzy-value temp ok) string)
(fuzzy-union (create-fuzzy-value temp ok)
             (create-fuzzy-value temp low)
             234)
(fuzzy-union (create-fuzzy-value temp ok)
             (create-fuzzy-value heat low))
(fuzzy-intersection)
(fuzzy-intersection (create-fuzzy-value temp ok))
(fuzzy-intersection 23 (create-fuzzy-value temp ok))
(fuzzy-intersection (create-fuzzy-value temp ok) string)
(fuzzy-intersection (create-fuzzy-value temp ok)
                    (create-fuzzy-value temp low)
                    234)
(fuzzy-intersection (create-fuzzy-value temp ok)
                    (create-fuzzy-value heat low))
(fuzzy-modify)
(fuzzy-modify (create-fuzzy-value temp ok) badmodifier)
(fuzzy-modify badfuzzyvalue very)
(fuzzy-modify (create-fuzzy-value temp ok) not thirdarg)
;;
;; valid calls
;;
(deftemplate system
   (slot name)
   (slot t1 (type FUZZY-VALUE temp))
   (slot t2 (type FUZZY-VALUE temp))
)

(plot-fuzzy-value t * nil nil
     (fuzzy-union (create-fuzzy-value temp ok)
                  (create-fuzzy-value temp high)))
(defrule test-fuzzy-union1
   ?f <- (system (name sysA) (t1 ok) (t2 low))
         (system (name sysB) (t1 ?t1B & not ok) (t2 ?t2B & low))
  =>
    (plot-fuzzy-value t * nil nil
           (fuzzy-union ?t1B ?t2B))
    (plot-fuzzy-value t * nil nil
           (fuzzy-union (get-fuzzy-slot ?f t1)
                        (get-fuzzy-slot ?f t2)))
    (plot-fuzzy-value t * nil nil
           (fuzzy-union (get-fuzzy-slot ?f t1) ?t2B))
    (bind ?t3 (assert (temp high)))
    (plot-fuzzy-value t * nil nil
           (fuzzy-union (get-fuzzy-slot ?t3) ?t2B))
)
(assert (system (name sysA) (t1 ok) (t2 low))
        (system (name sysB) (t1 not ok) (t2 low)))
(run)
(retract *)
(undefrule test-fuzzy-union1)

(plot-fuzzy-value t * nil nil
     (fuzzy-intersection (create-fuzzy-value temp ok)
                         (create-fuzzy-value temp high)))
(defrule test-fuzzy-intersection1
   ?f <- (system (name sysA) (t1 ok) (t2 low))
         (system (name sysB) (t1 ?t1B & not ok) (t2 ?t2B & low))
  =>
    (plot-fuzzy-value t * nil nil
           (fuzzy-intersection ?t1B ?t2B))
    (plot-fuzzy-value t * nil nil
           (fuzzy-intersection (get-fuzzy-slot ?f t1)
                               (get-fuzzy-slot ?f t2)))
    (plot-fuzzy-value t * nil nil
           (fuzzy-intersection (get-fuzzy-slot ?f t1) ?t2B))
    (bind ?t3 (assert (temp high)))
    (plot-fuzzy-value t * nil nil
           (fuzzy-intersection (get-fuzzy-slot ?t3) ?t2B))
)
(assert (system (name sysA) (t1 ok) (t2 low))
        (system (name sysB) (t1 not ok) (t2 low)))
(run)
(retract *)

(plot-fuzzy-value t * nil nil
     (fuzzy-modify (create-fuzzy-value temp ok) not))
(plot-fuzzy-value t * nil nil
     (fuzzy-modify (create-fuzzy-value temp ok) slightly))
(plot-fuzzy-value t * nil nil
     (fuzzy-modify (create-fuzzy-value temp ok) very))
(plot-fuzzy-value t * nil nil
     (fuzzy-modify (create-fuzzy-value temp ok) somewhat))
(defrule test-fuzzy-modify
  ?f <- (temp ?fv & high)
 =>
  (plot-fuzzy-value t * nil nil
    (fuzzy-modify (get-fuzzy-slot ?f) not))
  (plot-fuzzy-value t * nil nil
    (fuzzy-modify ?fv extremely))
  (plot-fuzzy-value t * nil nil
    (fuzzy-modify (get-fuzzy-slot ?f GenericFuzzySlot) intensify))
)
(assert (temp high))
(run)
(clear)


:: Tests for function get-fuzzy-slot
;;
;; first some invalid calls
(clear)
(deftemplate temp
  0 100 C
  ( (low (10 1) (50 0))
    (ok  (20 0) (50 1) (80 0))
    (high (50 0) (90 1))
  )
)
(deftemplate system
   (slot name)
   (slot t1 (type FUZZY-VALUE temp))
   (slot t2 (type FUZZY-VALUE temp))
)

(get-fuzzy-slot)
(get-fuzzy-slot 23)
(get-fuzzy-slot "rr" str)
(get-fuzzy-slot abc 456 "str")
(defglobal ?*x* = 0)
(bind ?*x* (assert (system (name sysA) (t1 low) (t2 ok))))
(get-fuzzy-slot ?*x* not-a-slot-name)
(get-fuzzy-slot ?*x* name)
;;
;; some valid calls
;;
(retract *)
(bind ?*x* (assert (system (name sysA) (t1 low) (t2 ok))))
(get-fuzzy-slot ?*x* t1)
(get-fuzzy-slot ?*x* t2)
(clear)

;;;***********************************************
;;; Testing moment-defuzzify and maximum-defuzzify
;;; for vertical and near vertical lines in fuzzy sets
;;;***********************************************

(deftemplate fz
 0 1 units
 ((fz1 (0.3 0.0) (0.3 0.4) (0.300001 0.0))
  (fz2 (0.3 0.0) (0.3 0.4) (0.3 0.0) (0.4 0.0) (0.4 0.4) (0.4 0.0))
  (fz3 (0.3 0.0) (0.3 0.4) (0.3 0.0) (0.4 0.0) (0.5 0.4) (0.6 0.3)
       (0.7 0.3) (0.8 0.0))
  (fz4 (0.4 0.0) (0.5 0.4) (0.6 0.3) (0.7 0.3) (0.8 0.0))
 )
)

(assert (fz fz1))
(defrule defuzzy
  ?f <- (fz ?)
=>
  (bind ?t (moment-defuzzify ?f))
  (printout t "Moment defuzzy of fz1 is: " ?t crlf)
  (bind ?t (maximum-defuzzify ?f))
  (printout t "Max. defuzzy of fz1 is: " ?t crlf)
)
(run)
(retract *)

(assert (fz fz2))
(defrule defuzzy
  ?f <- (fz ?)
=>
  (bind ?t (moment-defuzzify ?f))
  (printout t "Moment defuzzy of fz2 is: " ?t crlf)
  (bind ?t (maximum-defuzzify ?f))
  (printout t "Max. defuzzy of fz2 is: " ?t crlf)
)
(run)
(retract *)

(assert (fz fz3))
(defrule defuzzy
  ?f <- (fz ?)
=>
  (bind ?t (moment-defuzzify ?f))
  (printout t "Moment defuzzy of fz3 is: " ?t crlf)
  (bind ?t (maximum-defuzzify ?f))
  (printout t "Max. defuzzy of fz3 is: " ?t crlf)
)
(run)
(retract *)

(assert (fz fz4))
(defrule defuzzy
  ?f <- (fz ?)
=>
  (bind ?t (moment-defuzzify ?f))
  (printout t "Moment defuzzy of fz4 is: " ?t crlf)
  (bind ?t (maximum-defuzzify ?f))
  (printout t "Max. defuzzy of fz4 is: " ?t crlf)
)
(run)
(retract *)

;;;*******************************************************
;;; Test of callable function to plot fuzzy sets
;;;*******************************************************

(deftemplate fz-temp
 0 100
 ((same (50 0.5))
  (warm (40 0)(50 1)(60 0))
  (hot (50 0)(60 1))
  (real-hot (S 60 60))
  (spike (70 0)(70 1)(70 0))
 )
)

(deftemplate s
 (slot name (type SYMBOL))
 (slot temp (type FUZZY-VALUE fz-temp))
)
(retract *)
(assert (s (name t1)(temp warm)))
(defrule plot-one
  (s (name t1)(temp ?t1))
=>
  (plot-fuzzy-value t "+" 40 60 ?t1)
)
(run)
(defrule plot-two
  (s (name t1)(temp ?t1))
=>
  (plot-fuzzy-value t "+" 0 0 ?t1)  ; limits out of range  of t1 low
)
(run)
(defrule plot-three
  (s (name t1)(temp ?t1))
=>
  (plot-fuzzy-value t "+" 100 100 ?t1)  ; limits out of range of t1 high
)
(run)
(defrule plot-four
  (s (name t1)(temp ?t1))
=>
  (plot-fuzzy-value t "+" 60 60 ?t1)  ; t1 out of range of limits
)

(run)
(defrule plot-five
  (s (name t1)(temp ?t1))
=>
  (plot-fuzzy-value t "+.*" 40 60 ?t1) ; more than 1 printable character
)
(run)
(defrule plot-six
  (s (name t1)(temp ?t1))
=>
  (plot-fuzzy-value t "" 40 60 ?t1) ; not printable character specified
)

(run)
(defrule plot-seven
  (s (name t1)(temp ?t1))
=>
  (plot-fuzzy-value t "+" 40 ?t1) ; missing limit
)
(run)
(defrule plot-eight
  (s (name t1)(temp ?t1))
=>
  (plot-fuzzy-value t "+" 40 60) ; missing variable to plot
)
(run)
(defrule plot-nine
  (s (name t1)(temp ?t1))
=>
  (plot-fuzzy-value t 40 60 ?t1) ; missing printable character
)
(run)
(defrule plot-ten
  (s (name t1)(temp ?t1))
=>
  (plot-fuzzy-value "+" 40 60 ?t1) ; missing device specifier to print to
)
(run)





