(clear)                            ; dependencies and dependents
(deftemplate a
 -5 5 GLOBS
  ((negative-big (-5 1) (1 0))
   (zero (-2.5 0) (0 1) (2.5 0))
   (positive-big (-1 0) (5 1))
  )
)
(deftemplate b
 -5 5 GLOBS
  ((negative-big (-5 1) (0 0))
   (zero (-2.5 0) (0 1) (2.5 0))
   (positive-big (-1 0) (5 1))
  )
)
(deftemplate e
 0 1 GLOBS
  ((zero (0 1) (.5 0))
   (positive (.3 0) (1 1))
  )
)
(deftemplate g
0 1 GLOBS
  ((zero (0 1) (.5 0))
   (positive (.3 0) (1 1))
  )
)
(deftemplate h
  (slot x)
  (slot y (type FUZZY-VALUE a))
)
(defrule foo1 (logical (a negative-big) (b negative-big)) => (assert (e zero)))
(defrule foo2 (logical (b zero)) (h (x ?) (y negative-big)) (c) => (assert (e NOT positive)))
(defrule foo3 (logical (d) (b positive-big) (a positive-big)) (c) => (assert (e positive)))
(defrule foo4 (logical (d) (b negative-big) (a positive-big) (c)) => (assert (e NOT zero)))
(defrule foo5 (logical (a NOT zero) (c) (d)) => (assert (e NOT positive)))
(defrule foo6 (declare (salience -1)) (logical (c) (d)) => (assert (f)))
(defrule foo7 (declare (salience -1)) (logical (a zero)) (c) => (assert (f)))
(defrule foo8 (declare (salience -1)) (logical (c) (a zero)) (d) => (assert (f)))
(defrule foo9 (declare (salience -2)) (logical (d) (c) (b NOT negative-big)) => (assert (g zero OR positive)))
(assert (a zero) (b negative-big OR zero) (c) (d) (h (x 1) (y zero)))
(run)
(facts)
(dependencies)
(dependencies a)
(dependencies 9)
(dependencies 4)
(dependencies 5 6)
(dependencies 5)
(dependencies 2)
(dependents)
(dependents a)
(dependents 9)
(dependents 5 6)
(dependents 0)
(dependents 1)
(dependents 2)
(dependents 3)
(dependents 4)
(dependents 5)
(dependents 6)
(clear)        ; get-fact-duplication and set-fact-duplication
               ; NOTE: no effect for fuzzy facts (global contribution)
(deftemplate a
 -5 5 GLOBS
  ((negative-big (-5 1) (1 0))
   (zero (-2.5 0) (0 1) (2.5 0))
   (positive-big (-1 0) (5 1))
  )
)
(assert (a zero))
(assert (a negative-big))
(facts)
(get-fact-duplication)  
(set-fact-duplication TRUE)
(get-fact-duplication)
(clear)
(deftemplate a
 -5 5 GLOBS
  ((negative-big (-5 1) (1 0))
   (zero (-2.5 0) (0 1) (2.5 0))
   (positive-big (-1 0) (5 1))
  )
)
(assert (a zero))
(assert (a negative-big))
(facts)
(set-fact-duplication FALSE)
(get-fact-duplication)
(clear)
(deftemplate a
 -5 5 GLOBS
  ((negative-big (-5 1) (1 0))
   (zero (-2.5 0) (0 1) (2.5 0))
   (positive-big (-1 0) (5 1))
  )
)
(assert (a zero))
(assert (a negative-big))
(facts)
(clear)

;;;************************************************************
;;; Testing of fuzzy facts with more complex linguisitic
;;; expressions.
;;;************************************************************

(deftemplate fz
 0 100
  ((cold (20 1) (40 0))
   (hot (60 0) (80 1))
   (warm (30 0) (50 1) (70 0))
  )
)

(assert (fz NOT cold OR hot))
(facts)
(defrule xx
 (fz NOT cold OR hot)
=>
)
(plot-fuzzy-value t * nil nil 0)
(reset)

(assert (fz NOT [ cold OR hot ] ))
(facts)
(defrule xx
 (fz NOT [ cold OR hot ] )
=>
)
(plot-fuzzy-value t * nil nil 1)
(reset)

(assert (fz NOT cold AND hot))
(facts)
(defrule xx
 (fz NOT cold AND hot)
=>
)
(plot-fuzzy-value t * nil nil 1)
(reset)

(assert (fz NOT [ cold AND hot ] ))
(facts)
(defrule xx
 (fz NOT [ cold AND hot ] )
=>
)
(plot-fuzzy-value t * nil nil 1)
(reset)

(assert (fz cold AND hot OR warm))
(facts)
(defrule xx
 (fz cold AND hot OR warm)
=>
)
(plot-fuzzy-value t * nil nil 1)
(reset)

(assert (fz [ cold AND hot ] OR warm))
(facts)
(defrule xx
 (fz [ cold AND hot ] OR warm)
=>
)
(plot-fuzzy-value t * nil nil 1)
(reset)

(assert (fz [ [ [ hot ] ] ] ))
(facts)
(defrule xx
 (fz [ [ [ hot ] ] ] )
=>
)
(plot-fuzzy-value t * nil nil 1)
(reset)

(assert (fz NOT [ [ [ hot ] ] ] ))
(facts)
(defrule xx
 (fz NOT [ [ [ hot ] ] ] )
=>
)
(plot-fuzzy-value t * nil nil 1)
(reset)

(assert (fz very hot))
(facts)
(defrule xx
 (fz very hot)
=>
)
(plot-fuzzy-value t * nil nil 1)
(reset)

(assert (fz NOT very hot))
(facts)
(defrule xx
 (fz NOT very hot)
=>
)
(plot-fuzzy-value t * nil nil 1)
(reset)

(assert (fz more-or-less cold))
(facts)
(defrule xx
 (fz more-or-less cold)
=>
)
(plot-fuzzy-value t * nil nil 1)
(reset)

(assert (fz slightly hot))
(facts)
(defrule xx
 (fz slightly hot)
=>
)
(plot-fuzzy-value t * nil nil 1)
(reset)

(assert (fz intensify cold))
(facts)
(defrule xx
 (fz intensify cold)
=>
)
(plot-fuzzy-value t * nil nil 1)
(reset)

(assert (fz plus cold))
(facts)
(defrule xx
 (fz plus cold)
=>
)
(plot-fuzzy-value t * nil nil 1)
(reset)

(assert (fz NOT [ very hot ] ))
(facts)
(defrule xx
 (fz NOT [ very hot ] )
=>
)
(plot-fuzzy-value t * nil nil 1)
(reset)

(assert (fz NOT [ very hot ] OR cold))
(facts)
(defrule xx
 (fz NOT [ very hot ] OR cold)
=>
)
(plot-fuzzy-value t * nil nil 1)
(reset)

(assert (fz [ hot AND cold ] OR NOT [ hot AND cold ] ))
(facts)
(defrule xx
 (fz [ hot AND cold ] OR NOT [ hot AND cold ] )
=>
)
(plot-fuzzy-value t * nil nil 1)
(reset)

(assert (fz [ NOT cold OR [ very hot ] ] ))
(facts)
(defrule xx
 (fz [ NOT cold OR [ very hot ] ] )
=>
)
(plot-fuzzy-value t * nil nil 1)
(reset)

(assert (fz slightly cold OR [ very warm AND hot ] ))
(facts)
(defrule xx
 (fz slightly cold OR [ very warm AND hot ] )
=>
)
(plot-fuzzy-value t * nil nil 1)
(reset)

;;; The following assertions should produce an error

(assert (fz [ [ hot ] ))

(assert (fz slightly cold OR))

(assert (fz OR cold))

(assert (fz AND cold))

(assert (fz NOT AND hot))

(assert (fz [ NOT ] hot))

(assert (fz [ ] ))

(assert (fz [ ))

(assert (fz ] ))

(assert (fz slightly))

(assert (fz hot very))

(assert (fz hot [ OR ] cold))

(assert (fz hot cold))

(assert (fz immensely warm))

(clear)


;;;*****************************************************
;;;Test complex logical expressions in deftemplates.
;;;*****************************************************

(deftemplate fz
 0 100
  ((cold (20 1) (40 0))
   (hot (60 0) (80 1))
   (warm (30 0) (50 1) (70 0))
   (luke-warm NOT cold OR hot)
  )
)
(assert (fz luke-warm))
(plot-fuzzy-value t * nil nil 0)
(reset)

(deftemplate fz
 0 100
  ((cold (20 1) (40 0))
   (hot (60 0) (80 1))
   (warm (30 0) (50 1) (70 0))
   (luke-warm cold AND hot OR warm)
  )
)
(assert (fz luke-warm))
(plot-fuzzy-value t * nil nil 1)
(reset)

(deftemplate fz
 0 100
  ((cold (20 1) (40 0))
   (hot (60 0) (80 1))
   (warm (30 0) (50 1) (70 0))
   (not-hot NOT very hot)
  )
)
(assert (fz not-hot))
(plot-fuzzy-value t * nil nil 1)
(reset)

(deftemplate fz
 0 100
  ((cold (20 1) (40 0))
   (hot (60 0) (80 1))
   (warm (30 0) (50 1) (70 0))
   (sort-of-hot slightly hot)
  )
)
(assert (fz sort-of-hot))
(plot-fuzzy-value t * nil nil 1)
(reset)


