/*********************************** xclips.h *********************************/
/*                                                                            */
/******************************************************************************/
/*                                                                            */
/*        Authors:  BeBe Ly - NASA/Johnson Space Center                       */
/*                  Daniel J. McCoy - University of Houston - Downtown        */
/*                                                                            */
/******************************************************************************/

#ifndef TRUE
#define TRUE		1
#endif

#ifndef FALSE
#define FALSE 		0
#endif

#ifndef EOS
#define EOS 		'\0'
#endif

#define DELETE   	'\d'
#define BACKSPACE       '\b'
#define NEWLINE		'\n'
#define CR		'\r'
#define FORMFEED	'\f'
#define BLANK		' '
#define TAB		'\t'
#define ESC		'\033'
#define LOW_PRN_ASCII	' '
#define HIGH_PRN_ASCII	'~'
#define LOG_TABLE_SIZE  15
#define MAX_CHAR_IN_BUF 512

#define Facts           0
#define Rules           1
#define Activations     2
#define Compilations    3

#define RULEMNGR        0
#define DEFFACTSMNGR    1
#define DEFTEMPMNGR     2
#define AGENDAMNGR      3

#define EDIT            0
#define LOADBATCH       1
#define LOADBINARY      2
#define LOADFACTS       3
#define LOADRULES       4
#define DRIBBLEON       5
#define SAVEAS          6
#define SAVEBINARY      7
#define SAVEFACTS       8
#define SAVERULES       9
#define REVERT          10

#define INT_STA_CONSTRAINT_CHK    0
#define INT_DYN_CONSTRAINT_CHK    1
#define INT_RESET_GLOBALS        2
#define INT_SEQUENCE_OPT_REG     3
#define INT_INCREMENTAL_RESET    4
#define INT_AUTO_FLOAT_DIV       5
#define INT_FACT_DUPLICATION     6


#define SALIENCE_FLAG 0
#define STRATEGY_FLAG 1

#define MAX_WATCH 14

#define AGENDA_WIN   0
#define FACT_WIN     1
#define INSTANCE_WIN 2
#define GLOBAL_WIN  3
#define FOCUS_WIN   4
#define WINDOW_NUM     5


#define streq(a, b)   (strcmp((a), (b)) == 0)
#define balloc(nm,bk) (bk*)malloc (sizeof(bk)*((unsigned)nm))
#define release(node) free((char *)node)

typedef struct logname
  {
  char *name;
  struct logname *next;
  }LogName, *LogNamePtr;
#define salience_width 153
#define salience_height 18
static char salience_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x07, 0x03,
   0x00, 0x00, 0x00, 0xc0, 0x0f, 0x00, 0x70, 0x00, 0x00, 0x00, 0x06, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x66, 0x00, 0x06, 0x03, 0x00, 0x00, 0x00, 0xc0,
   0x00, 0x00, 0x60, 0x00, 0x00, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x06, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x60, 0x00,
   0x00, 0x03, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x06, 0x1e, 0x86, 0xc3,
   0xf3, 0xf1, 0x78, 0xc0, 0x60, 0xe6, 0x61, 0xcc, 0x3c, 0x0f, 0x87, 0xe7,
   0x03, 0xff, 0xff, 0x00, 0x3c, 0x30, 0x06, 0x63, 0x36, 0x9b, 0xcd, 0xc0,
   0x67, 0x06, 0x63, 0xcc, 0x60, 0x03, 0xc6, 0x6c, 0x06, 0xff, 0xff, 0x00,
   0x60, 0x3e, 0x06, 0xe3, 0x37, 0x1b, 0xfc, 0xc0, 0x60, 0xe6, 0x63, 0xcc,
   0x7c, 0x03, 0xc6, 0x6c, 0x06, 0xfe, 0x7f, 0x00, 0x60, 0x33, 0x06, 0x63,
   0x30, 0x1b, 0x0c, 0xc0, 0xc0, 0x33, 0x63, 0xcc, 0x66, 0x03, 0xc6, 0x6c,
   0x06, 0xfc, 0x3f, 0x00, 0x66, 0x33, 0x06, 0x63, 0x36, 0x9b, 0xcd, 0xc0,
   0xc0, 0x33, 0x63, 0xcc, 0x66, 0x33, 0xc6, 0x6c, 0x06, 0xf8, 0x1f, 0x00,
   0x3c, 0xbe, 0xdf, 0xcf, 0x33, 0xf3, 0x78, 0xc0, 0x8f, 0xe1, 0xfb, 0xf9,
   0x7c, 0x9e, 0x9f, 0x67, 0x06, 0xf0, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0xe0, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x03, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

#define strategy_width 153
#define strategy_height 18
static char strategy_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0xe0, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x30, 0x1b, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0xfe, 0xff, 0x01, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x18, 0x00, 0x00,
   0x03, 0x00, 0x00, 0x00, 0xfe, 0xff, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x30, 0x78, 0x7c, 0x3c, 0x0f, 0x8f, 0x6b, 0x06,
   0xfe, 0xff, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xe0, 0x19, 0xcc, 0x60, 0x83, 0xd9, 0x6c, 0x06, 0xfc, 0xff, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x0c, 0x7c,
   0x83, 0xdf, 0x6c, 0x06, 0xf8, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x0c, 0x66, 0x83, 0x81, 0x67, 0x06,
   0xf0, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x30, 0x9b, 0x0d, 0x66, 0xb3, 0xd9, 0xc0, 0x07, 0xe0, 0x1f, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xf1, 0x0c, 0x7c,
   0x1e, 0x8f, 0x07, 0x06, 0xc0, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x6c, 0x06,
   0x80, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xc7, 0x03, 0x00, 0x03, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};



