% 
%	CPS file created for use by developer
%	src/Shower_c.cps 
%
%	This file will not be changed by gnt once created
%

%***************************************************************************
%
%	ShowerProblem interface 
%
%	Routines to draw the Shower Piping in the ShowerPipingCanvas
%
%
%        ****** place this code in the file `src/Shower_c.cps' and also
%                  add the lines of code below to the file Shower.c in the routine 
%                  'runShower' after the call to autoloader() and before 
%                  the call to 'cps_open_windows()'. This will redefine the Paint routine for
%                  the ShowerPipingCanvas in whch we draw the layout of the simple
%                  hot and cold water pipes, etc.
%
%
%  Add this to Shower.c  |
%                                   |
%                                  \/
% /**************************************************
%
%    CUSTOM CODE TO:
%
%   Redefine the Paint routine for the ShowerPipingCanvas
% */
%
%     setShowerPipingCanvasPaint();  
%
% /*************************************************/


cdef setShowerPipingCanvasPaint()
    {
	/LineWidth 8 def
	/HotColor   { 1 0.44 0.02 }  def
	/ColdColor { 0 0 1 } def
	/ShowerColor { .3 .7 .6 }def
	/ValveFillColor {  0.95 0.5 0.55 } def
	/ValveStrokeColor { 0 0 0 } def

	/DrawHotLine
	          {
		LineWidth setlinewidth
		HotColor setrgbcolor
		100 0 moveto 0 200 rlineto
		96 200 moveto 100 0 rlineto
		stroke
	          }
	def

	/DrawColdLine
	          {
		LineWidth setlinewidth
		ColdColor setrgbcolor
		300 0 moveto 0 200 rlineto
		304 200 moveto -100 0 rlineto
		stroke
	          }
	def

	/DrawShowerLine
	          {
		LineWidth setlinewidth
		ShowerColor setrgbcolor
		200 196 moveto 0 70 rlineto
		196 270 moveto 50 0 rlineto
		stroke
		240 270 moveto 25 25 rlineto 0 -50 rlineto closepath
		fill  stroke
		16 184 184 32 32 rrectpath  fill 
		gsave 
		1.0 60.0 div setlinewidth
		gsave newpath
		270 285 translate  60 30 scale 0 -1 1 0 90 arc 
		stroke grestore
		gsave newpath
		270 275 translate  60 30 scale 0 -1 1 0 90 arc 
		stroke grestore
		gsave newpath
		270 265 translate  60 30 scale 0 -1 1 0 90 arc 
		stroke grestore
		gsave newpath
		270 255 translate  60 30 scale 0 -1 1 0 90 arc 
		stroke grestore
	          }
	def

	/DrawHotValve
	          {
		2 setlinewidth
		70 104 moveto 0 32 rlineto 60 -32 rlineto 0 32 rlineto closepath
		gsave ValveFillColor setrgbcolor fill grestore
		ValveStrokeColor setrgbcolor stroke
		55 120 moveto 15 0 rlineto stroke
		2.0 16.0 div setlinewidth
		gsave newpath
		55 120 translate 16 16 scale 0 0 1 90 270 arc  0 1 lineto
		gsave ValveFillColor setrgbcolor fill grestore
		ValveStrokeColor setrgbcolor stroke
		grestore		
	          }
	def

	/DrawColdValve
	          {
		2 setlinewidth
		270 104 moveto 0 32 rlineto 60 -32 rlineto 0 32 rlineto closepath
		gsave ValveFillColor setrgbcolor fill grestore
		ValveStrokeColor setrgbcolor stroke
		330 120 moveto 15 0 rlineto stroke
		2.0 16.0 div setlinewidth
		gsave newpath
		345 120 translate 16 16 scale 0 0 1 270 90 arc  0 -1 lineto
		gsave ValveFillColor setrgbcolor fill grestore
		ValveStrokeColor setrgbcolor stroke
		grestore
	          }
	def

	/Paint 
	          { 
		BG /FillCanvas self send
		/DrawHotLine self send
		/DrawColdLine self send
		/DrawShowerLine self send
		/DrawHotValve self send
		/DrawColdValve self send		  
	          }
	def
    }

 Shower_FuzzyShower_ShowerPipingCanvas send




cdef ps_setCurrenttime( string value )

	value /setvalue Shower_FuzzyShower_TimeText send


cdef ps_setColdPressureGuage( float value )

	value /setvalue Shower_FuzzyShower_ColdPressureGuage send

cdef ps_setHotPressureGuage( float value )

	value /setvalue Shower_FuzzyShower_HotPressureGuage send


cdef ps_setShowerFlowGuage( float value )

	value /setvalue Shower_FuzzyShower_ShowerFlowGuage send

cdef ps_setShowerTempGuage( float value )

	value /setvalue Shower_FuzzyShower_ShowerTempGuage send

cdef ps_setShowerFlowColor( string color )

	ColorDict color cvn get /BG Shower_FuzzyShower_ShowerFlowGuage send
	/setcolors Shower_FuzzyShower_ShowerFlowGuage send

cdef ps_setShowerTempColor( string color )

	ColorDict color cvn get /BG Shower_FuzzyShower_ShowerTempGuage send
	/setcolors Shower_FuzzyShower_ShowerTempGuage send



cdef ps_setColdTempSlider( float value )

	value /setvalue Shower_FuzzyShower_ColdTempSlider send

cdef ps_setHotTempSlider( float value )

	value /setvalue Shower_FuzzyShower_HotTempSlider send


cdef ps_setColdValveSlider( float value )

	value /setvalue Shower_FuzzyShower_ColdValveSlider send

cdef ps_setHotValveSlider( float value )

	value /setvalue Shower_FuzzyShower_HotValveSlider send





cdef ps_disableToilet1Choice()

	0 /Inactive /setvisualstate Shower_ChngPressureMenu send

cdef ps_enableToilet1Choice()

	0 /Active /setvisualstate Shower_ChngPressureMenu send

cdef ps_disableToilet2Choice()

	1 /Inactive /setvisualstate Shower_ChngPressureMenu send

cdef ps_enableToilet2Choice()

	1 /Active /setvisualstate Shower_ChngPressureMenu send

cdef ps_changeGardenHoseChoice( string ONorOFF )

	ONorOFF (on) eq 
	  { 2 /Inactive /setvisualstate Shower_ChngPressureMenu send
	    3 /Active /setvisualstate Shower_ChngPressureMenu send
	  }
	  { 3 /Inactive /setvisualstate Shower_ChngPressureMenu send
	    2 /Active /setvisualstate Shower_ChngPressureMenu send
	  }
	ifelse

cdef ps_disableWashingMachineChoice()

	5 /Inactive /setvisualstate Shower_ChngPressureMenu send

cdef ps_enableWashingMachineChoice()

	5 /Active /setvisualstate Shower_ChngPressureMenu send

cdef ps_disableDishwasherChoice()

	4 /Inactive /setvisualstate Shower_ChngPressureMenu send

cdef ps_enableDishwasherChoice()

	4 /Active /setvisualstate Shower_ChngPressureMenu send




cdef ps_setManualMode()

	[ 1 ] /setvalue Shower_FuzzyShower_ModeSetting send

cdef ps_setAutoMode()

	[ 0 ] /setvalue Shower_FuzzyShower_ModeSetting send




cdef ps_disableStartLoggingChoice()

	0 /Inactive /setvisualstate Shower_loggingMenu send

cdef ps_enableStartLoggingChoice()

	0 /Active /setvisualstate Shower_loggingMenu send




cdef ps_disableStopLoggingChoice()

	1 /Inactive /setvisualstate Shower_loggingMenu send

cdef ps_enableStopLoggingChoice()

	1 /Active /setvisualstate Shower_loggingMenu send


cdef ps_setDefaultStartLoggingChoice()

	0 /setdefault Shower_loggingMenu send

cdef ps_setDefaultStopLoggingChoice()

	1 /setdefault Shower_loggingMenu send



cdef cps_get_text(postscript field, string text, int tag) => tag (text)
    tag tagprint
    /value field send 
    dup null eq { pop () } if
    typedprint

cdef cps_set_text(postscript field, string value)
    value /setvalue field send



cdef cps_close_window( token window )
     /close window send


cdef cps_create_generic_notice( )
    /GenericNoticeButtons /Spaced framebuffer /new ClassButtons send def
    [(Confirm)] /setitemlist GenericNoticeButtons send
    0 /setdefault GenericNoticeButtons send
    {pop pop /close GenericNotice send} /setnotifier GenericNoticeButtons send

    /GenericNotice null framebuffer /new ClassNotice send def
    GenericNoticeButtons /setbuttons GenericNotice send
    emgr /activate GenericNotice send

cdef cps_call_confirm_notice( postscript querystring, postscript apex, token basewindow)
    querystring /settext GenericNotice send
    basewindow /setbasewindow GenericNotice send
    apex /open GenericNotice send



