
/*    Callback routine for the Shower Problem   */


#include "Events.h"
#include <stdio.h>
#include "ShowerSimulate.h"

#include <wire/wire.h>

extern int compressionFactor;/* used to control speed of simulation - 1 is
		    wall clock time -- >1 is faster than real time */


extern long getCurrentTime();
extern void addEvent();
extern void calc_Fx_Tx();

extern int SystemProblem;
extern int SystemMode;

extern float vc, vh;
extern float Fx, Tx;
extern float th, tc;
extern float ph,pc;

extern wire_Wire wire_Current();

extern int  t_scratch;

extern int tk_Shower_StartLoggingPopupWindow;	/* Token number for StartLoggingPopupWindow */
extern int tk_Shower_FuzzyShower;		/* Token number for FuzzyShower */


/* Callback for the FLUSH TOILET menu selection */

void FlushToilet1Callback()
{
	struct eventData *eData1, *eData2;
	long curTime;

	curTime = getCurrentTime();
	eData1 = (struct eventData *)malloc(sizeof(struct eventData));
	eData1->floatValue = -6.0;
	eData1->intValue = Toilet1FlushStart;
	addEvent( EVENT_changePressureCold, curTime, eData1 );

	/* NOTE: other events are added as event above is handled -- see ShowerSimulate.c */
}

void FlushToilet2Callback()
{
	struct eventData *eData1, *eData2;
	long curTime;

	curTime = getCurrentTime();
	eData1 = (struct eventData *)malloc(sizeof(struct eventData));
	eData1->floatValue = -8.0;
	eData1->intValue = Toilet2FlushStart;
	addEvent( EVENT_changePressureCold, curTime, eData1 );

	/* NOTE: other events are added as event above is handled -- see ShowerSimulate.c */
}


/* Callback for the GARDEN HOSE ON menu selection */

static float HosePressureChange = 0.0;

void GardenHoseOnCallback()
{
	struct eventData *eData1;
	long curTime;

	curTime = getCurrentTime();
	eData1 = (struct eventData *)malloc(sizeof(struct eventData));
	/* use a random drop in pressure */
	HosePressureChange = -8.0;
	eData1->floatValue = HosePressureChange;
	eData1->intValue = GardenHoseON;
	addEvent( EVENT_changePressureCold, curTime, eData1 );
}

void GardenHoseOffCallback()
{
	struct eventData *eData1;
	long curTime;

	curTime = getCurrentTime();
	eData1 = (struct eventData *)malloc(sizeof(struct eventData));
	eData1->floatValue = -HosePressureChange;
	eData1->intValue = GardenHoseOFF;
	addEvent( EVENT_changePressureCold, curTime, eData1 );
}


/* Callback for the DISHWASHER ON menu selection */

void DishwasherOnCallback()
{
   /* Cycle of machine is:
	30 seconds for hot water to enter machine (Cycle1)
	3 minutes wash and empty water
	30 seconds for hot water to enter machine (Cycle2)
	2 minutes for rinse
	3 minutes for dry
	machine off
   */
	
	struct eventData *eData1;
	long curTime;

	curTime = getCurrentTime();
	eData1 = (struct eventData *)malloc(sizeof(struct eventData));
	eData1->floatValue = -5.0;
	eData1->intValue = DishwasherStart;
	addEvent( EVENT_changePressureHot, curTime, eData1 );

	/* NOTE: other events are added as event above is handled -- see ShowerSimulate.c */
}


/* Callback for the WASHINGMACHINE ON menu selection */

void WashingMachineOnCallback()
{
   /* Cycle of machine is:
	2 min for 'warm' water to enter machine
	4 minutes wash and empty water
	2 min for 'warm' water to enter machine
	2 minutes for rinse
	3 minutes for spin dry and empty
	machine off
   */
	
	struct eventData *eData1, *eData1a;
	long curTime;

	curTime = getCurrentTime();
	eData1 = (struct eventData *)malloc(sizeof(struct eventData));
	eData1->floatValue = -6.0;
	eData1->intValue = WashingMachineStart;

	eData1a = (struct eventData *)malloc(sizeof(struct eventData));
	eData1a->floatValue = -3.0;
	eData1a->intValue = WashingMachineStart;
	addEvent( EVENT_changePressureHot, curTime, eData1 );
	addEvent( EVENT_changePressureCold, curTime, eData1a );

	/* NOTE: other events are added as events above are handled -- see ShowerSimulate.c */
}



/* Callback to react to selection of Mode Selection:

	0 - set to auto mode
	1 - set to manual mode
*/

void ModeSettingCallback(index)
   int index;
{
	if (index == 0)  /* auto mode */
	   {
		SystemProblem = NoProblem;
		SystemMode = AutoMode;
	   }
	else
	   {
		SystemMode = ManualMode;
	   }
}


/*  Moving the slider for cold valve */

void ColdValveCallback(slidervalue)

   float slidervalue;
{
   if (SystemMode == AutoMode)
      {
	/* set value back to 'vc'  --- auto mode !!! */

	ps_setColdValveSlider( vc );

      }
   else
      {
	/* set the valve value to indicated value */

	vc = slidervalue;

	calc_Fx_Tx();

        /*   Set all the sliders and guages etc. to correct values */

	ps_setShowerFlowGuage(Fx);
	ps_setShowerTempGuage(Tx);
	setShowerTempColor();
	setShowerFlowColor();

	psio_flush(wire_PSoutput(wire_Current()));

      }
}



/*  Moving the slider for hot valve */

void HotValveCallback(slidervalue)

   float slidervalue;
{
   if (SystemMode == AutoMode)
      {
	/* set value back to 'vh'  --- auto mode !!! */

	ps_setHotValveSlider( vh );

      }
   else
      {
	/* set the valve value to indicated value */

	vh = slidervalue;

	calc_Fx_Tx();

        /*   Set all the sliders and guages etc. to correct values */

	ps_setShowerFlowGuage(Fx);
	ps_setShowerTempGuage(Tx);
	setShowerTempColor();
	setShowerFlowColor();

	psio_flush(wire_PSoutput(wire_Current()));

      }
}



/* Callback for the Hot Temp slider  */

void HotTempSliderCallback(slidervalue)

   float slidervalue;
{
	th = slidervalue;

	calc_Fx_Tx();

        /*   Set the guages to correct values */

	ps_setShowerFlowGuage(Fx);
	ps_setShowerTempGuage(Tx);
	setShowerTempColor();
	setShowerFlowColor();

	psio_flush(wire_PSoutput(wire_Current()));
}



/* Callback for the Cold Temp slider  */

void ColdTempSliderCallback(slidervalue)

   float slidervalue;
{
	tc = slidervalue;
	calc_Fx_Tx();

        /*   Set the guages to correct values */

	ps_setShowerFlowGuage(Fx);
	ps_setShowerTempGuage(Tx);
	setShowerTempColor();
	setShowerFlowColor();

	psio_flush(wire_PSoutput(wire_Current()));
}



/*  CallBacks/functions for Data Logging */


FILE *logFile = NULL;
FILE *statFile = NULL;

int logFileIndex = -1;
int statFileIndex = -1;

/* arrays to hold data recorded during logging ... hold in arrays till logging stopped
    and then dump them to the files   xxx.log and xxx.stats where xxx is the name
    provided when the logging was started
*/

long  lfCurrTime[MaxLogFileEntries];
float  lfTx[MaxLogFileEntries], lfFx[MaxLogFileEntries], lfVh[MaxLogFileEntries], lfVc[MaxLogFileEntries];
float  lfPh[MaxLogFileEntries], lfPc[MaxLogFileEntries], lfTh[MaxLogFileEntries], lfTc[MaxLogFileEntries];

long sfStartTime[MaxStatFileEntries], sfEndTime[MaxStatFileEntries];  /* start/end time of T or P going out of range */
int    sfNumMoves[MaxStatFileEntries];  /* number of moves made during out of range period */
float sfT[MaxStatFileEntries], sfF[MaxStatFileEntries];   /* temp and flow at start of out of range period */

/* confirmnotice -- to notify of error in file spec */

void confirmnotice( text, apex, basewindow )

   char *text, *apex;
   int basewindow;
{
   static int noticenotloaded = TRUE;

   if (noticenotloaded)
      {
	cps_create_generic_notice();
	noticenotloaded = FALSE;
      }
   cps_call_confirm_notice( text, apex, basewindow );
}


/* Callback to start file logging */

void StartLoggingCallback()

{
    char dirBuffer[256], fileBuffer[256], message[512], logfilename[256], statfilename[256];

    if (logFile == NULL)
       { /* turn on logging -- called from the popup window when Start Logging button pressed */ 
	cps_get_text("Shower_StartLoggingPopupWindow_StartLogDirTextfield", dirBuffer, t_scratch);
	cps_get_text("Shower_StartLoggingPopupWindow_StartLogFileTextfield", fileBuffer, t_scratch);
	if (dirBuffer[0] == '\0') strcpy( dirBuffer, ".");
	sprintf(logfilename, "%s/%s.log", dirBuffer, fileBuffer);
	sprintf(statfilename, "%s/%s.stat", dirBuffer, fileBuffer);
	if (fileBuffer[0] != '\0' 
	    && (NULL != (logFile = fopen(logfilename,"w")))
	     && (NULL != (statFile = fopen(statfilename,"w"))))
	   { /* opened file successfully */
	         statFileIndex = -1;
	         ps_enableStopLoggingChoice();
    	         ps_disableStartLoggingChoice();
	         ps_setDefaultStopLoggingChoice();
	         cps_close_window( tk_Shower_StartLoggingPopupWindow );

	         /* record the current position of the system */
	         logFileIndex = 0;
	         lfCurrTime[logFileIndex] = getCurrentTime();
	         lfTx[logFileIndex] = Tx;
	         lfFx[logFileIndex] = Fx;
	         lfVh[logFileIndex] = vh;
	         lfVc[logFileIndex] = vc;
	         lfPh[logFileIndex] = ph;
	         lfPc[logFileIndex] = pc;
	         lfTh[logFileIndex] = th;
	         lfTc[logFileIndex] = tc;
	   }
	else
	   { /* file not found */
	     sprintf( message, "[(Unable to Open file(s) for logging: ) (%s,%s)]", logfilename, statfilename); 
	      if (logFile != NULL) fclose(logFile);
	      if (statFile != NULL) fclose(statFile);
	     confirmnotice( message, "[0 Shower_StartLoggingPopupWindow_StartLoggingButton]", tk_Shower_FuzzyShower);
	   }
       }
}


/*  Callback to stop file logging  -- called from the Stop Logging menu choice */

void StopLoggingCallback()

{    /* turn off logging */

    int i;
    float totTime = 0;
    int    totMoves = 0;
    float timediff = 0;

   /* record the final position of the system */
         logFileIndex++;
         lfCurrTime[logFileIndex] = getCurrentTime();
         lfTx[logFileIndex] = Tx;
         lfFx[logFileIndex] = Fx;
         lfVh[logFileIndex] = vh;
         lfVc[logFileIndex] = vc;
         lfPh[logFileIndex] = ph;
         lfPc[logFileIndex] = pc;
         lfTh[logFileIndex] = th;
         lfTc[logFileIndex] = tc;

    /* write out the data stored in the arrays of logging data and close the files */

    for (i=0; i<=logFileIndex; i++)
        {
              fprintf(logFile,"%ld %f %f %f %f %f %f %f %f\n",
	 lfCurrTime[i], lfTx[i], lfFx[i], lfVh[i], lfVc[i], lfPh[i], lfPc[i], lfTh[i], lfTc[i]);
        }
     logFileIndex = -1;

    fprintf(statFile, "     StartTime    Temp      Flow   ElapsedTime    Moves\n\n");

    for (i=0; i<=statFileIndex; i++)
        {
              timediff = (sfEndTime[i] - sfStartTime[i])/1000.0;
              fprintf(statFile,"%3d%10.3f%10.3f%10.3f%10.3f%10d\n",
	 i, sfStartTime[i]/1000.0, sfT[i], sfF[i], timediff, sfNumMoves[i]);
              totTime = totTime + timediff;
              totMoves = totMoves + sfNumMoves[i];
        }

     fprintf(statFile, "\nAvg. Time to Recover: %f\nAvg. Number Moves: %f\n\n",
                 totTime/(float)(statFileIndex+1), totMoves/(float)(statFileIndex+1) );

     statFileIndex = -1;

    fclose( logFile );
    logFile = NULL;
    fclose( statFile );
    statFile = NULL;
    ps_enableStartLoggingChoice();
    ps_disableStopLoggingChoice();
    ps_setDefaultStartLoggingChoice();
}
