;;;************************************************************
;;; FUZZY DEFTEMPLATE ERROR CHECKING
;;;
;;; This file tests a number of common errors which can be
;;; made with fuzzy deftemplates. Among the errors tested are
;;;   (1) incomplete range (universe) spec
;;;   (2) incorrect order of range specifiers
;;;   (3) units spec not a simple word
;;;   (4) no terms specified
;;;   (5) modifier function does not exist
;;;   (6) invalid function used to define fuzzy set for a term
;;;   (7) S, Z, PI functions - parameters generate x values out of range
;;;                          - parameters out of range
;;;   (8) singleton specification - x values not in increasing order
;;;                               - x values out of range
;;;                               - y values out of range
;;;   (9) term name not a single word
;;;
;;; When the file is loaded, only those fuzzy deftemplates with
;;; the aok prefix should be displayed with a list-deftemplates
;;; command is executed. Any deftemplates shown with the prefix
;;; bad indicate that an error was not detected. The number of
;;; deftemplates listed should also be checked to make sure all
;;; of the aok deftemplates loaded properly.
;;;************************************************************

;;;********************************************
;;; These deftemplates check incomplete range (universe) spec
;;;********************************************

(deftemplate bad-fz01
 10 DEGREES
 ((t1 (s 0 5))
 )
 ()
)
(deftemplate bad-fz02
 10 30 40 DEGREES
 ((t1 (s 0 5))
 )
 ()
)
(deftemplate aok-fz01
 0 10 DEGREES
 ((t1 (s 0 5))
 )
 ()
)

;;;********************************************
;;; This deftemplate checks incorrect order of range specifiers
;;;********************************************

(deftemplate bad-fz03
 10 0 DEGREES
 ((t1 (s 0 5))
 )
 ()
)

;;;********************************************
;;; This deftemplate checks units spec not a simple word
;;;********************************************

(deftemplate bad-fz04
 0 10 DEGREES CENTIGRADE
 ((t1 (s 0 5))
 )
 ()
)

;;;********************************************
;;; This deftemplate checks no terms specified
;;;********************************************

(deftemplate bad-fz05
 0 10 DEGREES-C
 (
 )
 ()
)

;;;********************************************
;;; This deftemplate checks modifier function does not exist
;;;********************************************

(deftemplate bad-fz06
 0 10 DEGREES-C
 ((t1 (s 0 5))
 )
 ((very bad-function)
 )
)
(deftemplate aok-fz02
 0 10 DEGREES-C
 ((t1 (s 0 5))
 )
 ((very sqr)
 )
)

;;;********************************************
;;; This deftemplate checks invalid function used to define
;;; fuzzy set for a term
;;;********************************************

(deftemplate bad-fz07
 0 10 DEGREES-C
 ((t1 (bad-term-fcn 0 5))
 )
 ((very sqr)
 )
)

;;;********************************************
;;; These deftemplates check S, Z, PI functions - parameter errors
;;;********************************************

(deftemplate bad-fz08
 0 10 DEGREES-C
 ((t1 (S 0 15))
 )
 ((very sqr)
 )
)
(deftemplate bad-fz09
 0 10 DEGREES-C
 ((t1 (Z -5 5))
 )
 ((very sqr)
 )
)
(deftemplate bad-fz10
 0 10 DEGREES-C
 ((t1 (PI 10 5))
 )
 ((very sqr)
 )
)
(deftemplate bad-fz11
 0 10 DEGREES-C
 ((t1 (PI 5 15))
 )
 ((very sqr)
 )
)
(deftemplate bad-fz12
 0 10 DEGREES-C
 ((t1 (PI 0 5))
 )
 ((very sqr)
 )
)
(deftemplate aok-fz03
 0 10 DEGREES-C
 ((t1 (S 0 8))
 )
 ((very sqr)
 )
)
(deftemplate aok-fz04
 0 10 DEGREES-C
 ((t1 (Z 0 5))
 )
 ((very sqr)
 )
)
(deftemplate aok-fz05
 0 10 DEGREES-C
 ((t1 (PI 2 5))
 )
 ((very sqr)
 )
)

;;;********************************************
;;; These deftemplates check singleton specification errors
;;;********************************************

(deftemplate bad-fz13
 0 10 DEGREES-C
 ((t1 (0 1) (0 .5) (5 0))
 )
 ((very sqr)
 )
)
(deftemplate bad-fz14
 0 10 DEGREES-C
 ((t1 (15 0) (20 1))
 )
 ((very sqr)
 )
)
(deftemplate bad-fz15
 0 10 DEGREES-C
 ((t1 (0 0) (5 2) (10 1))
 )
 ((very sqr)
 )
)
(deftemplate aok-fz06
 0 10 DEGREES-C
 ((t1 (0 0) (5 1) (10 1))
 )
 ((very sqr)
 )
)

;;;********************************************
;;; This deftemplate checks term name not a single word
;;;********************************************

(deftemplate bad-fz16
 0 10 DEGREES-C
 ((room temperature (s 0 5))
 )
 ((very sqr)
 )
)
