;;; test the fuzzy functions for accessing fuzzy fact information
;;; checking errors in parameters and proper operation of functions
(clear)
(deftemplate temp
 0 100 DEGREES-C
 ((low (0 1) (10 0))
  (med (5 0) (50 1) (95 0))
 )
 ((very sqr)
 )
)
(deftemplate temp-nounits
 0 100
 ((low (0 1) (10 0))
  (med (5 0) (50 1) (95 0))
 )
 ((very sqr)
 )
)

;; access via the template name
(get-u       temp)
(get-u-from  temp)
(get-u-to    temp)
(get-u-units temp)
(get-u       temp-nounits)
(get-u-from  temp-nounits)
(get-u-to    temp-nounits)
(get-u-units temp-nounits)

;; incorrect name specified for get-u functions
(get-u abc)
(get-u-from asd)
(get-u-to abs)
(get-u-units asdf)
(get-u "string-not-allowed")

;; access via the fact specifier
(assert (temp-nounits low))
(assert (temp med))
(defrule temp-discourse
  ?t <- (temp ?)
  ?t2 <- (temp-nounits ?)
=>
  (bind ?s (get-u-units ?t2))
  (printout t "units of the universe of discourse are: " ?s "[should be empty string]"  crlf)
  (bind ?s (get-u ?t))
  (printout t "limits of the universe of discourse are: " ?s crlf)
  (bind ?s (get-u-from ?t))
  (printout t "lower limit of the universe of discourse is: " ?s crlf)
  (bind ?s (get-u-to ?t))
  (printout t "upper limit of the universe of discourse is: " ?s crlf)
  (bind ?s (get-u-units ?t))
  (printout t "units of the universe of discourse are: " ?s crlf)
)
(defrule temp-set
  ?t <- (temp ?)
=>
  (bind ?s (get-fs ?t))
  (printout t "fuzzy set is: " ?s crlf)
  (bind ?n (get-fs-length ?t))
  (printout t "number of pairs in fuzzy set is: " ?n crlf)
  (bind ?x (get-fs-x ?t (- ?n 1)))
  (bind ?y (get-fs-y ?t (- ?n 1)))
  (printout t "last pair are: " ?x "," ?y crlf)
  (bind ?x (get-fs-x ?t 0))
  (bind ?y (get-fs-y ?t 0))
  (printout t "first pair are: " ?x "," ?y crlf)
)
(run)
(defrule out-range-low
  ?t <- (temp ?)
=>
  (bind ?n (get-fs-length ?t))
  (bind ?x (get-fs-x ?t (- ?n (+ ?n 1))))
  (bind ?y (get-fs-y ?t (- ?n (+ ?n 1))))
  (printout t "out of range low: " ?x "," ?y crlf)
)
(run)
(clear)
(deftemplate temp
 0 100 DEGREES-C
 ((low (0 1) (10 0))
  (med (5 0) (50 1) (95 0))
 )
 ((very sqr)
 )
)
(assert (temp med))
(defrule out-range-high
  ?t <- (temp ?)
=>
  (bind ?n (get-fs-length ?t))
  (bind ?x (get-fs-x ?t (+ ?n 1)))
  (bind ?y (get-fs-y ?t (+ ?n 1)))
  (printout t "out of range high: " ?x "," ?y crlf)
)
(run)

