;;; Companion to fctpcstr test used to test fuzzy patterns in rules
(deftemplate fz
 0 100
  ((cold (0 1) (60 0))
   (hot (40 0) (100 1))
  )
  ((very sqr)
  )
)
(defrule fz-error-1a  ; Undefined term or modifier
  (fz quite cold)
  =>
)
(defrule fz-error-1b  ; Undefined term or modifier
  (fz very temperate)
  =>
)
(defrule fz-error-2  ; missing [  ]
  (fz NOT cold OR hot)
  =>
)
(defrule fz-error-3a  ; only one NOT allowed
  (fz NOT NOT cold)
  =>
)
(defrule fz-error-3b  ; only one NOT allowed
  (fz NOT hot OR NOT cold)
  =>
)
(defrule fz-error-4  ; missing [
  (fz NOT cold OR hot ])
  =>
)
(defrule fz-error-5  ; missing term
  (fz cold OR very)
  =>
)
(defrule fz-error-6  ; missing expression
  (fz NOT [ cold OR ])
  =>
)
(defrule fz-error-7a ; missing OR
  (fz hot cold)
  =>
)
(defrule fz-error-7b  ; missing OR
  (fz NOT [ cold hot ])
  =>
)
(defrule fz-error-7c  ; missing OR
  (fz cold very hot)
  =>
)
(defrule fz-error-8  ; NOT in incorrect position
  (fz very NOT hot)
  =>
)
(defrule fz-error-9a  ; missing spaces around [ ]'s
  (fz NOT[ hot OR cold ])
  =>
)
(defrule fz-error-9b  ; missing spaces around [ ]'s
  (fz NOT [hot OR cold ])
  =>
)
(defrule fz-error-9c  ; missing spaces around [ ]'s
  (fz NOT [ hot OR cold])
  =>
)
