;; This file 'cfthrshld.bat' is used to test the calculation of certainty
;; factors for rules and the use of the threshold value to determine if a
;; rule should fire or not 
;;
;; Also tests the set-CF-evaluation

(deftemplate temp
  0 100 degrees-C
 ((low (0 1) (25 0))
  (med (20 0) (50 1) (80 0))
  (high (75 0) (100 0))
 )
 ((very sqr)
  (more-or-less sqrt)
 )
)

(deftemplate move-hot-valve
  0 1
 ((little (Z 0 0.3))
  (medium (PI 0.3 0.5))
  (lots   (S 0.7 1))
 ) 
()
)

(threshold 0.5) ;; threshold is 0.5

(defrule rule1 ;; default rule CF 1.0
  (temp low)
  (msg  ?msg)
 =>
  (printout t ?msg crlf)
)
;; calculated rule CF should be 0.4
(assert (msg "Should NOT see this message!")
        (temp low) CF 0.4
)
(run)
(reset)
;; calculated rule CF should be 0.6
(assert (msg "Should see this message!")
        (temp low) CF 0.6
)
(run)
(reset)
;; calculated rule CF should be 1.0 -- all matching facts have CF 1.0
(assert (msg "Should see this message!")
        (temp low)
)
(run)
(undefrule rule1)
(reset)
(defrule rule2 ;; rule CF 0.8
  (declare (CF 0.8))
  (temp med)
  (msg  ?msg)
 =>
  (assert (move-hot-valve little))
  (printout t ?msg crlf)
)
;; calculated rule CF should be 0.4 * 0.8 = 0.32
(assert (msg "Should NOT see this message!")
        (temp low) CF 0.4
)
(run)
(reset)
;; calculated rule CF should be 0.7 * 0.8 = 0.56
(assert (msg "Should see this message!")
        (temp low) CF 0.7
)
(run)
(reset)
(undefrule rule2)
(defrule rule3 ;; rule CF 0.9 -- multiple matching facts with certainties != 1.0
  (declare (CF 0.9))
  (temp med)
  (move-hot-valve little)
  (msg  ?msg)
 =>
  (printout t ?msg crlf)
)
;; calculated rule CF should be (min(0.4, 0.6) * 0.9 = 0.36
(assert (msg "Should NOT see this message!")
        (temp low) CF 0.6
        (move-hot-valve medium) CF 0.4
)
(run)
(reset)
;; calculated rule CF should be min(0.7, 0.8) * 0.9 = 0.63
(assert (msg "Should see this message!")
        (temp low) CF 0.7
        (move-hot-valve medium) CF 0.8
)
(run)
(reset)
(undefrule rule3)

;; using rules with dynamic certainty factor calulations

(defglobal ?*cf* = 0.9)
(set-CF-evaluation when-activated)

(defrule rule4 ;; default rule CF set by global variable
  (declare (CF ?*cf*))
  (temp low)
  (msg  ?msg)
  (move-hot-valve little)
 =>
  (printout t ?msg crlf)
)
;; calculated rule CF should be min(0.4, 0.6) * ?*cf* = 0.36
(assert (msg "Should NOT see this message!")
        (temp low) CF 0.4
        (move-hot-valve medium) CF 0.6
)
(run)
(reset)
(defglobal ?*cf* = 0.7)
;; calculated rule CF should be min(0.6, 0.9) * ?*cf* = 0.42
(assert (msg "Should NOT see this message!")
        (temp low) CF 0.6
        (move-hot-valve medium) CF 0.9
)
(run)
(reset)
(defglobal ?*cf* = 0.8) ;; rule CF will be 0.8
;; calculated rule CF should be min(0.8, 0.9) * ?*cf* = 0.64
(assert (msg "Should see this message!")
        (temp low) CF 0.8
        (move-hot-valve medium) CF 0.9
)
(run)
(reset)

(undefrule rule4)
(reset)

(defglobal ?*cf* = 0.7)
(defrule rule5 ;; default rule CF set by global variable
  (declare (CF (+ 0.2 ?*cf*)))
  (temp low)
  (msg  ?msg)
  (move-hot-valve little)
 =>
  (printout t ?msg crlf)
)
;; calculated rule CF should be min(0.4, 0.6) * (+ 0.2 ?*cf*) = 0.36
(assert (msg "Should NOT see this message!")
        (temp low) CF 0.4
        (move-hot-valve medium) CF 0.6
)
(run)
(reset)
(defglobal ?*cf* = 0.5) ;; rule CF will be 0.7
;; calculated rule CF should be min(0.6, 0.9) * (+ 0.2 ?*cf*) = 0.42
(assert (msg "Should NOT see this message!")
        (temp low) CF 0.6
        (move-hot-valve medium) CF 0.9
)
(run)
(reset)
(defglobal ?*cf* = 0.8) ;; rule CF will be 1.0
;; calculated rule CF should be min(0.8, 0.9) * (+ 0.2 ?*cf*) = 0.8
(assert (msg "Should see this message!")
        (temp low) CF 0.8
        (move-hot-valve medium) CF 0.9
)
(run)
(reset)

(undefrule rule5)
(reset)

;; using not in a pattern with a fuzzy variable 
;; see if can still calc the rule's calculated CF
(defrule rule6 ;; default rule CF 1.0
  (temp low)
  (msg  ?msg)
  (not (some fact))
 =>
  (printout t ?msg crlf)
)
;; calculated rule CF should be 0.4
(assert (msg "Should NOT see this message!")
        (temp low) CF 0.4
)
(run)
(reset)
;; calculated rule CF should be 0.6
(assert (msg "Should see this message!")
        (temp low) CF 0.6
)
(run)
(reset)
;; calculated rule CF should be 1.0 -- all matching facts have CF 1.0
(assert (msg "Should see this message!")
        (temp low)
)
(run)
(undefrule rule6)
(reset)
