   /*******************************************************/
   /*      "C" Language Integrated Production System      */
   /*                                                     */
   /*                  A Product Of The                   */
   /*             Software Technology Branch              */
   /*             NASA - Johnson Space Center             */
   /*                                                     */
   /*             CLIPS Version 6.00  05/12/93            */
   /*                                                     */
   /*             FUZZY REASONING HEADER FILE             */
   /*******************************************************/

/*************************************************************/
/* Purpose:                                                  */
/*                                                           */
/* Principal Programmer(s):                                  */
/*      Gary D. Riley                                        */
/*      Brian L. Donnell                                     */
/*      Bob Orchard (NRCC - Nat'l Research Council of Canada)*/
/*                  (Fuzzy reasoning extensions)             */
/*                  (certainty factors for facts and rules)  */
/*                  (extensions to run command)              */
/*                                                           */
/* Contributing Programmer(s):                               */
/*                                                           */
/* Revision History:                                         */
/*                                                           */
/*************************************************************/



#ifndef _H_fuzzyval
#define _H_fuzzyval




/*********************************************************************/
/* FUZZY_VALUE STRUCTURE:                                            */
/*                                                                   */
/*  whichDeftemplate - deftemplate associated with the fuzzy value   */
/*  shareable - true if the fuzzy value can be shared                */
/*  name of the fuzzy value (linguistic expression)                  */
/*  maxn  - size of x and y arrays                                   */
/*  n     - number of elements in x and y in use                     */
/*  x,y   - the membership values                                    */
/*                                                                   */
/*  NOTE: at some time FuzzyValues should become atomic types. We    */
/*        go most of the way by making them hashed etc.              */
/*        to be careful since they may change due to global          */
/*                                                                   */
/*********************************************************************/
struct fuzzy_value
  {
    struct symbolHashNode *name;  /* the fuzzy value name eg. (lv very cold) => "very cold" is name */
    int maxn;
    int n;
    double *x;
    double *y;
  };
  
  


#endif
