   /*******************************************************/
   /*      "C" Language Integrated Production System      */
   /*                                                     */
   /*                  A Product Of The                   */
   /*             Software Technology Branch              */
   /*             NASA - Johnson Space Center             */
   /*                                                     */
   /*             CLIPS Version 6.00  05/12/93            */
   /*                                                     */
   /*             FUZZY REASONING HEADER FILE             */
   /*******************************************************/

/*************************************************************/
/* Purpose:                                                  */
/*                                                           */
/* Principal Programmer(s):                                  */
/*      Gary D. Riley                                        */
/*      Brian L. Donnell                                     */
/*      Bob Orchard (NRCC - Nat'l Research Council of Canada)*/
/*                  (Fuzzy reasoning extensions)             */
/*                  (certainty factors for facts and rules)  */
/*                  (extensions to run command)              */
/*                                                           */
/* Contributing Programmer(s):                               */
/*                                                           */
/* Revision History:                                         */
/*                                                           */
/*************************************************************/



#ifndef _H_fuzzylv
#define _H_fuzzylv


#if DEFFUNCTION_CONSTRUCT

#ifndef _H_dffnxfun
#include "dffnxfun.h"
#endif

#endif

#ifndef _H_extnfunc
#include "extnfunc.h"
#endif


struct primary_term;
struct modifier;
struct universe;



/******************************************************************/
/* LINGUISTIC VARIABLE STRUCTURE:                                 */
/******************************************************************/
struct fuzzyLv   
  {
   struct universe *u_ptr;
   struct primary_term *primary_term_list;
   struct modifier *modifier_list;
  };

/******************************************************************/
/* PRIMARY_TERM STRUCTURE:                                        */
/******************************************************************/
struct primary_term
  {
   FUZZY_VALUE_HN *fuzzy_value_description;
   struct primary_term *next;
  };

/*******************************************************************/
/*  MODIFIER STRUCTURE:                                            */
/*******************************************************************/
struct modifier
  {
   struct symbolHashNode *name;
   struct FunctionDefinition *function;  
#if DEFFUNCTION_CONSTRUCT
   DEFFUNCTION *deffunction;
#endif
   struct modifier *next;
  };


  
/*********************************************************************/
/* UNIVERSE OF DISCOURSE STRUCTURE:                                  */
/*********************************************************************/
struct universe
  {
   double from;
   double to;
   struct symbolHashNode *units;
  };


/*********************************************************************/
/* Combined FUZZYLV &UNIVERSE OF DISCOURSE STRUCTURE:                */
/*                                                                   */
/* Used in creating files for compiled system -- constructs to c     */
/*********************************************************************/
struct LvUniverse
    {
	   struct fuzzyLv lv;
	   struct universe u;
	};



#endif
